package io.kubernetes.client.openapi.models;

import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.lang.String;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class V2beta2ResourceMetricSourceFluentImpl<A extends V2beta2ResourceMetricSourceFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V2beta2ResourceMetricSourceFluent<A> {

    private String name;
    private V2beta2MetricTargetBuilder target;

    public V2beta2ResourceMetricSourceFluentImpl() { 
    }


    public V2beta2ResourceMetricSourceFluentImpl(V2beta2ResourceMetricSource instance) { 
        this.withName(instance.getName());

        this.withTarget(instance.getTarget());

    }


    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name=name; return (A) this;
    }

    public Boolean hasName() {
        return this.name != null;
    }

    public A withNewName(String arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuilder arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuffer arg1) {
        return (A)withName(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildTarget instead.
 * @return The buildable object.
 */
@Deprecated public V2beta2MetricTarget getTarget() {
        return this.target!=null?this.target.build():null;
    }

    public V2beta2MetricTarget buildTarget() {
        return this.target!=null?this.target.build():null;
    }

    public A withTarget(V2beta2MetricTarget target) {
        _visitables.get("target").remove(this.target);
        if (target!=null){ this.target= new V2beta2MetricTargetBuilder(target); _visitables.get("target").add(this.target);} return (A) this;
    }

    public Boolean hasTarget() {
        return this.target != null;
    }

    public V2beta2ResourceMetricSourceFluent.TargetNested<A> withNewTarget() {
        return new TargetNestedImpl();
    }

    public V2beta2ResourceMetricSourceFluent.TargetNested<A> withNewTargetLike(V2beta2MetricTarget item) {
        return new TargetNestedImpl(item);
    }

    public V2beta2ResourceMetricSourceFluent.TargetNested<A> editTarget() {
        return withNewTargetLike(getTarget());
    }

    public V2beta2ResourceMetricSourceFluent.TargetNested<A> editOrNewTarget() {
        return withNewTargetLike(getTarget() != null ? getTarget(): new V2beta2MetricTargetBuilder().build());
    }

    public V2beta2ResourceMetricSourceFluent.TargetNested<A> editOrNewTargetLike(V2beta2MetricTarget item) {
        return withNewTargetLike(getTarget() != null ? getTarget(): item);
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        V2beta2ResourceMetricSourceFluentImpl that = (V2beta2ResourceMetricSourceFluentImpl) o;
        if (name != null ? !name.equals(that.name) :that.name != null) return false;
        if (target != null ? !target.equals(that.target) :that.target != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(name,  target,  super.hashCode());
    }

    public class TargetNestedImpl<N> extends V2beta2MetricTargetFluentImpl<V2beta2ResourceMetricSourceFluent.TargetNested<N>> implements V2beta2ResourceMetricSourceFluent.TargetNested<N>,io.kubernetes.client.fluent.Nested<N> {
        private final V2beta2MetricTargetBuilder builder;

        TargetNestedImpl(V2beta2MetricTarget item) {
            this.builder = new V2beta2MetricTargetBuilder(this, item);
        }

        TargetNestedImpl() {
            this.builder = new V2beta2MetricTargetBuilder(this);
        }

        public N and() {
             return (N) V2beta2ResourceMetricSourceFluentImpl.this.withTarget(builder.build());
        }

        public N endTarget() {
             return and();
        }
    }


}
