package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V2beta2ExternalMetricStatusBuilder extends V2beta2ExternalMetricStatusFluentImpl<V2beta2ExternalMetricStatusBuilder> implements VisitableBuilder<V2beta2ExternalMetricStatus,V2beta2ExternalMetricStatusBuilder> {

    V2beta2ExternalMetricStatusFluent<?> fluent;
    Boolean validationEnabled;

    public V2beta2ExternalMetricStatusBuilder() { 
        this(true);
    }


    public V2beta2ExternalMetricStatusBuilder(Boolean validationEnabled) { 
        this(new V2beta2ExternalMetricStatus(), validationEnabled);
    }


    public V2beta2ExternalMetricStatusBuilder(V2beta2ExternalMetricStatusFluent<?> fluent) { 
        this(fluent, true);
    }


    public V2beta2ExternalMetricStatusBuilder(V2beta2ExternalMetricStatusFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new V2beta2ExternalMetricStatus(), validationEnabled);
    }


    public V2beta2ExternalMetricStatusBuilder(V2beta2ExternalMetricStatusFluent<?> fluent,V2beta2ExternalMetricStatus instance) { 
        this(fluent, instance, true);
    }


    public V2beta2ExternalMetricStatusBuilder(V2beta2ExternalMetricStatusFluent<?> fluent,V2beta2ExternalMetricStatus instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withCurrent(instance.getCurrent());

        fluent.withMetric(instance.getMetric());

        this.validationEnabled = validationEnabled; 
    }


    public V2beta2ExternalMetricStatusBuilder(V2beta2ExternalMetricStatus instance) { 
        this(instance,true);
    }


    public V2beta2ExternalMetricStatusBuilder(V2beta2ExternalMetricStatus instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withCurrent(instance.getCurrent());

        this.withMetric(instance.getMetric());

        this.validationEnabled = validationEnabled; 
    }


    public V2beta2ExternalMetricStatus build() {
        V2beta2ExternalMetricStatus buildable = new V2beta2ExternalMetricStatus();
        buildable.setCurrent(fluent.getCurrent());
        buildable.setMetric(fluent.getMetric());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        V2beta2ExternalMetricStatusBuilder that = (V2beta2ExternalMetricStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
