package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1beta1SELinuxStrategyOptionsBuilder extends V1beta1SELinuxStrategyOptionsFluentImpl<V1beta1SELinuxStrategyOptionsBuilder> implements VisitableBuilder<V1beta1SELinuxStrategyOptions,V1beta1SELinuxStrategyOptionsBuilder> {

    V1beta1SELinuxStrategyOptionsFluent<?> fluent;
    Boolean validationEnabled;

    public V1beta1SELinuxStrategyOptionsBuilder() { 
        this(true);
    }


    public V1beta1SELinuxStrategyOptionsBuilder(Boolean validationEnabled) { 
        this(new V1beta1SELinuxStrategyOptions(), validationEnabled);
    }


    public V1beta1SELinuxStrategyOptionsBuilder(V1beta1SELinuxStrategyOptionsFluent<?> fluent) { 
        this(fluent, true);
    }


    public V1beta1SELinuxStrategyOptionsBuilder(V1beta1SELinuxStrategyOptionsFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new V1beta1SELinuxStrategyOptions(), validationEnabled);
    }


    public V1beta1SELinuxStrategyOptionsBuilder(V1beta1SELinuxStrategyOptionsFluent<?> fluent,V1beta1SELinuxStrategyOptions instance) { 
        this(fluent, instance, true);
    }


    public V1beta1SELinuxStrategyOptionsBuilder(V1beta1SELinuxStrategyOptionsFluent<?> fluent,V1beta1SELinuxStrategyOptions instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withRule(instance.getRule());

        fluent.withSeLinuxOptions(instance.getSeLinuxOptions());

        this.validationEnabled = validationEnabled; 
    }


    public V1beta1SELinuxStrategyOptionsBuilder(V1beta1SELinuxStrategyOptions instance) { 
        this(instance,true);
    }


    public V1beta1SELinuxStrategyOptionsBuilder(V1beta1SELinuxStrategyOptions instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withRule(instance.getRule());

        this.withSeLinuxOptions(instance.getSeLinuxOptions());

        this.validationEnabled = validationEnabled; 
    }


    public V1beta1SELinuxStrategyOptions build() {
        V1beta1SELinuxStrategyOptions buildable = new V1beta1SELinuxStrategyOptions();
        buildable.setRule(fluent.getRule());
        buildable.setSeLinuxOptions(fluent.getSeLinuxOptions());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        V1beta1SELinuxStrategyOptionsBuilder that = (V1beta1SELinuxStrategyOptionsBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
