package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1beta1CronJobSpecBuilder extends V1beta1CronJobSpecFluentImpl<V1beta1CronJobSpecBuilder> implements VisitableBuilder<V1beta1CronJobSpec,V1beta1CronJobSpecBuilder> {

    V1beta1CronJobSpecFluent<?> fluent;
    Boolean validationEnabled;

    public V1beta1CronJobSpecBuilder() { 
        this(true);
    }


    public V1beta1CronJobSpecBuilder(Boolean validationEnabled) { 
        this(new V1beta1CronJobSpec(), validationEnabled);
    }


    public V1beta1CronJobSpecBuilder(V1beta1CronJobSpecFluent<?> fluent) { 
        this(fluent, true);
    }


    public V1beta1CronJobSpecBuilder(V1beta1CronJobSpecFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new V1beta1CronJobSpec(), validationEnabled);
    }


    public V1beta1CronJobSpecBuilder(V1beta1CronJobSpecFluent<?> fluent,V1beta1CronJobSpec instance) { 
        this(fluent, instance, true);
    }


    public V1beta1CronJobSpecBuilder(V1beta1CronJobSpecFluent<?> fluent,V1beta1CronJobSpec instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withConcurrencyPolicy(instance.getConcurrencyPolicy());

        fluent.withFailedJobsHistoryLimit(instance.getFailedJobsHistoryLimit());

        fluent.withJobTemplate(instance.getJobTemplate());

        fluent.withSchedule(instance.getSchedule());

        fluent.withStartingDeadlineSeconds(instance.getStartingDeadlineSeconds());

        fluent.withSuccessfulJobsHistoryLimit(instance.getSuccessfulJobsHistoryLimit());

        fluent.withSuspend(instance.getSuspend());

        this.validationEnabled = validationEnabled; 
    }


    public V1beta1CronJobSpecBuilder(V1beta1CronJobSpec instance) { 
        this(instance,true);
    }


    public V1beta1CronJobSpecBuilder(V1beta1CronJobSpec instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withConcurrencyPolicy(instance.getConcurrencyPolicy());

        this.withFailedJobsHistoryLimit(instance.getFailedJobsHistoryLimit());

        this.withJobTemplate(instance.getJobTemplate());

        this.withSchedule(instance.getSchedule());

        this.withStartingDeadlineSeconds(instance.getStartingDeadlineSeconds());

        this.withSuccessfulJobsHistoryLimit(instance.getSuccessfulJobsHistoryLimit());

        this.withSuspend(instance.getSuspend());

        this.validationEnabled = validationEnabled; 
    }


    public V1beta1CronJobSpec build() {
        V1beta1CronJobSpec buildable = new V1beta1CronJobSpec();
        buildable.setConcurrencyPolicy(fluent.getConcurrencyPolicy());
        buildable.setFailedJobsHistoryLimit(fluent.getFailedJobsHistoryLimit());
        buildable.setJobTemplate(fluent.getJobTemplate());
        buildable.setSchedule(fluent.getSchedule());
        buildable.setStartingDeadlineSeconds(fluent.getStartingDeadlineSeconds());
        buildable.setSuccessfulJobsHistoryLimit(fluent.getSuccessfulJobsHistoryLimit());
        buildable.setSuspend(fluent.isSuspend());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        V1beta1CronJobSpecBuilder that = (V1beta1CronJobSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
