package io.kubernetes.client.openapi.models;

import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.kubernetes.client.fluent.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class V1beta1CSINodeDriverFluentImpl<A extends V1beta1CSINodeDriverFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1beta1CSINodeDriverFluent<A> {

    private V1beta1VolumeNodeResourcesBuilder allocatable;
    private String name;
    private String nodeID;
    private List<String> topologyKeys;

    public V1beta1CSINodeDriverFluentImpl() { 
    }


    public V1beta1CSINodeDriverFluentImpl(V1beta1CSINodeDriver instance) { 
        this.withAllocatable(instance.getAllocatable());

        this.withName(instance.getName());

        this.withNodeID(instance.getNodeID());

        this.withTopologyKeys(instance.getTopologyKeys());

    }


    
/**
 * This method has been deprecated, please use method buildAllocatable instead.
 * @return The buildable object.
 */
@Deprecated public V1beta1VolumeNodeResources getAllocatable() {
        return this.allocatable!=null?this.allocatable.build():null;
    }

    public V1beta1VolumeNodeResources buildAllocatable() {
        return this.allocatable!=null?this.allocatable.build():null;
    }

    public A withAllocatable(V1beta1VolumeNodeResources allocatable) {
        _visitables.get("allocatable").remove(this.allocatable);
        if (allocatable!=null){ this.allocatable= new V1beta1VolumeNodeResourcesBuilder(allocatable); _visitables.get("allocatable").add(this.allocatable);} return (A) this;
    }

    public Boolean hasAllocatable() {
        return this.allocatable != null;
    }

    public V1beta1CSINodeDriverFluent.AllocatableNested<A> withNewAllocatable() {
        return new AllocatableNestedImpl();
    }

    public V1beta1CSINodeDriverFluent.AllocatableNested<A> withNewAllocatableLike(V1beta1VolumeNodeResources item) {
        return new AllocatableNestedImpl(item);
    }

    public V1beta1CSINodeDriverFluent.AllocatableNested<A> editAllocatable() {
        return withNewAllocatableLike(getAllocatable());
    }

    public V1beta1CSINodeDriverFluent.AllocatableNested<A> editOrNewAllocatable() {
        return withNewAllocatableLike(getAllocatable() != null ? getAllocatable(): new V1beta1VolumeNodeResourcesBuilder().build());
    }

    public V1beta1CSINodeDriverFluent.AllocatableNested<A> editOrNewAllocatableLike(V1beta1VolumeNodeResources item) {
        return withNewAllocatableLike(getAllocatable() != null ? getAllocatable(): item);
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name=name; return (A) this;
    }

    public Boolean hasName() {
        return this.name != null;
    }

    public A withNewName(String arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuilder arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuffer arg1) {
        return (A)withName(new String(arg1));
    }

    public String getNodeID() {
        return this.nodeID;
    }

    public A withNodeID(String nodeID) {
        this.nodeID=nodeID; return (A) this;
    }

    public Boolean hasNodeID() {
        return this.nodeID != null;
    }

    public A withNewNodeID(String arg1) {
        return (A)withNodeID(new String(arg1));
    }

    public A withNewNodeID(StringBuilder arg1) {
        return (A)withNodeID(new String(arg1));
    }

    public A withNewNodeID(StringBuffer arg1) {
        return (A)withNodeID(new String(arg1));
    }

    public A addToTopologyKeys(int index,String item) {
        if (this.topologyKeys == null) {this.topologyKeys = new ArrayList<String>();}
        this.topologyKeys.add(index, item);
        return (A)this;
    }

    public A setToTopologyKeys(int index,String item) {
        if (this.topologyKeys == null) {this.topologyKeys = new ArrayList<String>();}
        this.topologyKeys.set(index, item); return (A)this;
    }

    public A addToTopologyKeys(String... items) {
        if (this.topologyKeys == null) {this.topologyKeys = new ArrayList<String>();}
        for (String item : items) {this.topologyKeys.add(item);} return (A)this;
    }

    public A addAllToTopologyKeys(Collection<String> items) {
        if (this.topologyKeys == null) {this.topologyKeys = new ArrayList<String>();}
        for (String item : items) {this.topologyKeys.add(item);} return (A)this;
    }

    public A removeFromTopologyKeys(String... items) {
        for (String item : items) {if (this.topologyKeys!= null){ this.topologyKeys.remove(item);}} return (A)this;
    }

    public A removeAllFromTopologyKeys(Collection<String> items) {
        for (String item : items) {if (this.topologyKeys!= null){ this.topologyKeys.remove(item);}} return (A)this;
    }

    public List<String> getTopologyKeys() {
        return this.topologyKeys;
    }

    public String getTopologyKey(int index) {
        return this.topologyKeys.get(index);
    }

    public String getFirstTopologyKey() {
        return this.topologyKeys.get(0);
    }

    public String getLastTopologyKey() {
        return this.topologyKeys.get(topologyKeys.size() - 1);
    }

    public String getMatchingTopologyKey(io.kubernetes.client.fluent.Predicate<String> predicate) {
        for (String item: topologyKeys) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingTopologyKey(io.kubernetes.client.fluent.Predicate<String> predicate) {
        for (String item: topologyKeys) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withTopologyKeys(List<String> topologyKeys) {
        if (this.topologyKeys != null) { _visitables.get("topologyKeys").removeAll(this.topologyKeys);}
        if (topologyKeys != null) {this.topologyKeys = new ArrayList<String>(); for (String item : topologyKeys){this.addToTopologyKeys(item);}} else { this.topologyKeys = null;} return (A) this;
    }

    public A withTopologyKeys(String... topologyKeys) {
        if (this.topologyKeys != null) {this.topologyKeys.clear();}
        if (topologyKeys != null) {for (String item :topologyKeys){ this.addToTopologyKeys(item);}} return (A) this;
    }

    public Boolean hasTopologyKeys() {
        return topologyKeys != null && !topologyKeys.isEmpty();
    }

    public A addNewTopologyKey(String arg1) {
        return (A)addToTopologyKeys(new String(arg1));
    }

    public A addNewTopologyKey(StringBuilder arg1) {
        return (A)addToTopologyKeys(new String(arg1));
    }

    public A addNewTopologyKey(StringBuffer arg1) {
        return (A)addToTopologyKeys(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        V1beta1CSINodeDriverFluentImpl that = (V1beta1CSINodeDriverFluentImpl) o;
        if (allocatable != null ? !allocatable.equals(that.allocatable) :that.allocatable != null) return false;
        if (name != null ? !name.equals(that.name) :that.name != null) return false;
        if (nodeID != null ? !nodeID.equals(that.nodeID) :that.nodeID != null) return false;
        if (topologyKeys != null ? !topologyKeys.equals(that.topologyKeys) :that.topologyKeys != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(allocatable,  name,  nodeID,  topologyKeys,  super.hashCode());
    }

    public class AllocatableNestedImpl<N> extends V1beta1VolumeNodeResourcesFluentImpl<V1beta1CSINodeDriverFluent.AllocatableNested<N>> implements V1beta1CSINodeDriverFluent.AllocatableNested<N>,io.kubernetes.client.fluent.Nested<N> {
        private final V1beta1VolumeNodeResourcesBuilder builder;

        AllocatableNestedImpl(V1beta1VolumeNodeResources item) {
            this.builder = new V1beta1VolumeNodeResourcesBuilder(this, item);
        }

        AllocatableNestedImpl() {
            this.builder = new V1beta1VolumeNodeResourcesBuilder(this);
        }

        public N and() {
             return (N) V1beta1CSINodeDriverFluentImpl.this.withAllocatable(builder.build());
        }

        public N endAllocatable() {
             return and();
        }
    }


}
