package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1PriorityLevelConfigurationBuilder extends V1alpha1PriorityLevelConfigurationFluentImpl<V1alpha1PriorityLevelConfigurationBuilder> implements VisitableBuilder<V1alpha1PriorityLevelConfiguration,V1alpha1PriorityLevelConfigurationBuilder> {

    V1alpha1PriorityLevelConfigurationFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1PriorityLevelConfigurationBuilder() { 
        this(true);
    }


    public V1alpha1PriorityLevelConfigurationBuilder(Boolean validationEnabled) { 
        this(new V1alpha1PriorityLevelConfiguration(), validationEnabled);
    }


    public V1alpha1PriorityLevelConfigurationBuilder(V1alpha1PriorityLevelConfigurationFluent<?> fluent) { 
        this(fluent, true);
    }


    public V1alpha1PriorityLevelConfigurationBuilder(V1alpha1PriorityLevelConfigurationFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new V1alpha1PriorityLevelConfiguration(), validationEnabled);
    }


    public V1alpha1PriorityLevelConfigurationBuilder(V1alpha1PriorityLevelConfigurationFluent<?> fluent,V1alpha1PriorityLevelConfiguration instance) { 
        this(fluent, instance, true);
    }


    public V1alpha1PriorityLevelConfigurationBuilder(V1alpha1PriorityLevelConfigurationFluent<?> fluent,V1alpha1PriorityLevelConfiguration instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion());

        fluent.withKind(instance.getKind());

        fluent.withMetadata(instance.getMetadata());

        fluent.withSpec(instance.getSpec());

        fluent.withStatus(instance.getStatus());

        this.validationEnabled = validationEnabled; 
    }


    public V1alpha1PriorityLevelConfigurationBuilder(V1alpha1PriorityLevelConfiguration instance) { 
        this(instance,true);
    }


    public V1alpha1PriorityLevelConfigurationBuilder(V1alpha1PriorityLevelConfiguration instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion());

        this.withKind(instance.getKind());

        this.withMetadata(instance.getMetadata());

        this.withSpec(instance.getSpec());

        this.withStatus(instance.getStatus());

        this.validationEnabled = validationEnabled; 
    }


    public V1alpha1PriorityLevelConfiguration build() {
        V1alpha1PriorityLevelConfiguration buildable = new V1alpha1PriorityLevelConfiguration();
        buildable.setApiVersion(fluent.getApiVersion());
        buildable.setKind(fluent.getKind());
        buildable.setMetadata(fluent.getMetadata());
        buildable.setSpec(fluent.getSpec());
        buildable.setStatus(fluent.getStatus());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        V1alpha1PriorityLevelConfigurationBuilder that = (V1alpha1PriorityLevelConfigurationBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
