package io.kubernetes.client.openapi.models;

import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.lang.String;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1LimitResponseFluentImpl<A extends V1alpha1LimitResponseFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1alpha1LimitResponseFluent<A> {

    private V1alpha1QueuingConfigurationBuilder queuing;
    private String type;

    public V1alpha1LimitResponseFluentImpl() { 
    }


    public V1alpha1LimitResponseFluentImpl(V1alpha1LimitResponse instance) { 
        this.withQueuing(instance.getQueuing());

        this.withType(instance.getType());

    }


    
/**
 * This method has been deprecated, please use method buildQueuing instead.
 * @return The buildable object.
 */
@Deprecated public V1alpha1QueuingConfiguration getQueuing() {
        return this.queuing!=null?this.queuing.build():null;
    }

    public V1alpha1QueuingConfiguration buildQueuing() {
        return this.queuing!=null?this.queuing.build():null;
    }

    public A withQueuing(V1alpha1QueuingConfiguration queuing) {
        _visitables.get("queuing").remove(this.queuing);
        if (queuing!=null){ this.queuing= new V1alpha1QueuingConfigurationBuilder(queuing); _visitables.get("queuing").add(this.queuing);} return (A) this;
    }

    public Boolean hasQueuing() {
        return this.queuing != null;
    }

    public V1alpha1LimitResponseFluent.QueuingNested<A> withNewQueuing() {
        return new QueuingNestedImpl();
    }

    public V1alpha1LimitResponseFluent.QueuingNested<A> withNewQueuingLike(V1alpha1QueuingConfiguration item) {
        return new QueuingNestedImpl(item);
    }

    public V1alpha1LimitResponseFluent.QueuingNested<A> editQueuing() {
        return withNewQueuingLike(getQueuing());
    }

    public V1alpha1LimitResponseFluent.QueuingNested<A> editOrNewQueuing() {
        return withNewQueuingLike(getQueuing() != null ? getQueuing(): new V1alpha1QueuingConfigurationBuilder().build());
    }

    public V1alpha1LimitResponseFluent.QueuingNested<A> editOrNewQueuingLike(V1alpha1QueuingConfiguration item) {
        return withNewQueuingLike(getQueuing() != null ? getQueuing(): item);
    }

    public String getType() {
        return this.type;
    }

    public A withType(String type) {
        this.type=type; return (A) this;
    }

    public Boolean hasType() {
        return this.type != null;
    }

    public A withNewType(String arg1) {
        return (A)withType(new String(arg1));
    }

    public A withNewType(StringBuilder arg1) {
        return (A)withType(new String(arg1));
    }

    public A withNewType(StringBuffer arg1) {
        return (A)withType(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        V1alpha1LimitResponseFluentImpl that = (V1alpha1LimitResponseFluentImpl) o;
        if (queuing != null ? !queuing.equals(that.queuing) :that.queuing != null) return false;
        if (type != null ? !type.equals(that.type) :that.type != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(queuing,  type,  super.hashCode());
    }

    public class QueuingNestedImpl<N> extends V1alpha1QueuingConfigurationFluentImpl<V1alpha1LimitResponseFluent.QueuingNested<N>> implements V1alpha1LimitResponseFluent.QueuingNested<N>,io.kubernetes.client.fluent.Nested<N> {
        private final V1alpha1QueuingConfigurationBuilder builder;

        QueuingNestedImpl(V1alpha1QueuingConfiguration item) {
            this.builder = new V1alpha1QueuingConfigurationBuilder(this, item);
        }

        QueuingNestedImpl() {
            this.builder = new V1alpha1QueuingConfigurationBuilder(this);
        }

        public N and() {
             return (N) V1alpha1LimitResponseFluentImpl.this.withQueuing(builder.build());
        }

        public N endQueuing() {
             return and();
        }
    }


}
