package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1ClusterRoleBindingListBuilder extends V1alpha1ClusterRoleBindingListFluentImpl<V1alpha1ClusterRoleBindingListBuilder> implements VisitableBuilder<V1alpha1ClusterRoleBindingList,V1alpha1ClusterRoleBindingListBuilder> {

    V1alpha1ClusterRoleBindingListFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1ClusterRoleBindingListBuilder() { 
        this(true);
    }


    public V1alpha1ClusterRoleBindingListBuilder(Boolean validationEnabled) { 
        this(new V1alpha1ClusterRoleBindingList(), validationEnabled);
    }


    public V1alpha1ClusterRoleBindingListBuilder(V1alpha1ClusterRoleBindingListFluent<?> fluent) { 
        this(fluent, true);
    }


    public V1alpha1ClusterRoleBindingListBuilder(V1alpha1ClusterRoleBindingListFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new V1alpha1ClusterRoleBindingList(), validationEnabled);
    }


    public V1alpha1ClusterRoleBindingListBuilder(V1alpha1ClusterRoleBindingListFluent<?> fluent,V1alpha1ClusterRoleBindingList instance) { 
        this(fluent, instance, true);
    }


    public V1alpha1ClusterRoleBindingListBuilder(V1alpha1ClusterRoleBindingListFluent<?> fluent,V1alpha1ClusterRoleBindingList instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion());

        fluent.withItems(instance.getItems());

        fluent.withKind(instance.getKind());

        fluent.withMetadata(instance.getMetadata());

        this.validationEnabled = validationEnabled; 
    }


    public V1alpha1ClusterRoleBindingListBuilder(V1alpha1ClusterRoleBindingList instance) { 
        this(instance,true);
    }


    public V1alpha1ClusterRoleBindingListBuilder(V1alpha1ClusterRoleBindingList instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion());

        this.withItems(instance.getItems());

        this.withKind(instance.getKind());

        this.withMetadata(instance.getMetadata());

        this.validationEnabled = validationEnabled; 
    }


    public V1alpha1ClusterRoleBindingList build() {
        V1alpha1ClusterRoleBindingList buildable = new V1alpha1ClusterRoleBindingList();
        buildable.setApiVersion(fluent.getApiVersion());
        buildable.setItems(fluent.getItems());
        buildable.setKind(fluent.getKind());
        buildable.setMetadata(fluent.getMetadata());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        V1alpha1ClusterRoleBindingListBuilder that = (V1alpha1ClusterRoleBindingListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
