package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1TopologySelectorTermBuilder extends V1TopologySelectorTermFluentImpl<V1TopologySelectorTermBuilder> implements VisitableBuilder<V1TopologySelectorTerm,V1TopologySelectorTermBuilder> {

    V1TopologySelectorTermFluent<?> fluent;
    Boolean validationEnabled;

    public V1TopologySelectorTermBuilder() { 
        this(true);
    }


    public V1TopologySelectorTermBuilder(Boolean validationEnabled) { 
        this(new V1TopologySelectorTerm(), validationEnabled);
    }


    public V1TopologySelectorTermBuilder(V1TopologySelectorTermFluent<?> fluent) { 
        this(fluent, true);
    }


    public V1TopologySelectorTermBuilder(V1TopologySelectorTermFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new V1TopologySelectorTerm(), validationEnabled);
    }


    public V1TopologySelectorTermBuilder(V1TopologySelectorTermFluent<?> fluent,V1TopologySelectorTerm instance) { 
        this(fluent, instance, true);
    }


    public V1TopologySelectorTermBuilder(V1TopologySelectorTermFluent<?> fluent,V1TopologySelectorTerm instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withMatchLabelExpressions(instance.getMatchLabelExpressions());

        this.validationEnabled = validationEnabled; 
    }


    public V1TopologySelectorTermBuilder(V1TopologySelectorTerm instance) { 
        this(instance,true);
    }


    public V1TopologySelectorTermBuilder(V1TopologySelectorTerm instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withMatchLabelExpressions(instance.getMatchLabelExpressions());

        this.validationEnabled = validationEnabled; 
    }


    public V1TopologySelectorTerm build() {
        V1TopologySelectorTerm buildable = new V1TopologySelectorTerm();
        buildable.setMatchLabelExpressions(fluent.getMatchLabelExpressions());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        V1TopologySelectorTermBuilder that = (V1TopologySelectorTermBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
