package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1SysctlBuilder extends V1SysctlFluentImpl<V1SysctlBuilder> implements VisitableBuilder<V1Sysctl,V1SysctlBuilder> {

    V1SysctlFluent<?> fluent;
    Boolean validationEnabled;

    public V1SysctlBuilder() { 
        this(true);
    }


    public V1SysctlBuilder(Boolean validationEnabled) { 
        this(new V1Sysctl(), validationEnabled);
    }


    public V1SysctlBuilder(V1SysctlFluent<?> fluent) { 
        this(fluent, true);
    }


    public V1SysctlBuilder(V1SysctlFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new V1Sysctl(), validationEnabled);
    }


    public V1SysctlBuilder(V1SysctlFluent<?> fluent,V1Sysctl instance) { 
        this(fluent, instance, true);
    }


    public V1SysctlBuilder(V1SysctlFluent<?> fluent,V1Sysctl instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withName(instance.getName());

        fluent.withValue(instance.getValue());

        this.validationEnabled = validationEnabled; 
    }


    public V1SysctlBuilder(V1Sysctl instance) { 
        this(instance,true);
    }


    public V1SysctlBuilder(V1Sysctl instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withName(instance.getName());

        this.withValue(instance.getValue());

        this.validationEnabled = validationEnabled; 
    }


    public V1Sysctl build() {
        V1Sysctl buildable = new V1Sysctl();
        buildable.setName(fluent.getName());
        buildable.setValue(fluent.getValue());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        V1SysctlBuilder that = (V1SysctlBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
