package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1ServerAddressByClientCIDRBuilder extends V1ServerAddressByClientCIDRFluentImpl<V1ServerAddressByClientCIDRBuilder> implements VisitableBuilder<V1ServerAddressByClientCIDR,V1ServerAddressByClientCIDRBuilder> {

    V1ServerAddressByClientCIDRFluent<?> fluent;
    Boolean validationEnabled;

    public V1ServerAddressByClientCIDRBuilder() { 
        this(true);
    }


    public V1ServerAddressByClientCIDRBuilder(Boolean validationEnabled) { 
        this(new V1ServerAddressByClientCIDR(), validationEnabled);
    }


    public V1ServerAddressByClientCIDRBuilder(V1ServerAddressByClientCIDRFluent<?> fluent) { 
        this(fluent, true);
    }


    public V1ServerAddressByClientCIDRBuilder(V1ServerAddressByClientCIDRFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new V1ServerAddressByClientCIDR(), validationEnabled);
    }


    public V1ServerAddressByClientCIDRBuilder(V1ServerAddressByClientCIDRFluent<?> fluent,V1ServerAddressByClientCIDR instance) { 
        this(fluent, instance, true);
    }


    public V1ServerAddressByClientCIDRBuilder(V1ServerAddressByClientCIDRFluent<?> fluent,V1ServerAddressByClientCIDR instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withClientCIDR(instance.getClientCIDR());

        fluent.withServerAddress(instance.getServerAddress());

        this.validationEnabled = validationEnabled; 
    }


    public V1ServerAddressByClientCIDRBuilder(V1ServerAddressByClientCIDR instance) { 
        this(instance,true);
    }


    public V1ServerAddressByClientCIDRBuilder(V1ServerAddressByClientCIDR instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withClientCIDR(instance.getClientCIDR());

        this.withServerAddress(instance.getServerAddress());

        this.validationEnabled = validationEnabled; 
    }


    public V1ServerAddressByClientCIDR build() {
        V1ServerAddressByClientCIDR buildable = new V1ServerAddressByClientCIDR();
        buildable.setClientCIDR(fluent.getClientCIDR());
        buildable.setServerAddress(fluent.getServerAddress());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        V1ServerAddressByClientCIDRBuilder that = (V1ServerAddressByClientCIDRBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
