package io.kubernetes.client.openapi.models;

import java.lang.StringBuffer;
import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Fluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.lang.String;
import java.lang.Boolean;
import io.kubernetes.client.fluent.Predicate;

public interface V1RuleWithOperationsFluent<A extends V1RuleWithOperationsFluent<A>> extends Fluent<A> {


    public A addToApiGroups(int index,String item);
    public A setToApiGroups(int index,String item);
    public A addToApiGroups(String... items);
    public A addAllToApiGroups(Collection<String> items);
    public A removeFromApiGroups(String... items);
    public A removeAllFromApiGroups(Collection<String> items);
    public List<String> getApiGroups();
    public String getApiGroup(int index);
    public String getFirstApiGroup();
    public String getLastApiGroup();
    public String getMatchingApiGroup(io.kubernetes.client.fluent.Predicate<String> predicate);
    public Boolean hasMatchingApiGroup(io.kubernetes.client.fluent.Predicate<String> predicate);
    public A withApiGroups(List<String> apiGroups);
    public A withApiGroups(String... apiGroups);
    public Boolean hasApiGroups();
    public A addNewApiGroup(String arg1);
    public A addNewApiGroup(StringBuilder arg1);
    public A addNewApiGroup(StringBuffer arg1);
    public A addToApiVersions(int index,String item);
    public A setToApiVersions(int index,String item);
    public A addToApiVersions(String... items);
    public A addAllToApiVersions(Collection<String> items);
    public A removeFromApiVersions(String... items);
    public A removeAllFromApiVersions(Collection<String> items);
    public List<String> getApiVersions();
    public String getApiVersion(int index);
    public String getFirstApiVersion();
    public String getLastApiVersion();
    public String getMatchingApiVersion(io.kubernetes.client.fluent.Predicate<String> predicate);
    public Boolean hasMatchingApiVersion(io.kubernetes.client.fluent.Predicate<String> predicate);
    public A withApiVersions(List<String> apiVersions);
    public A withApiVersions(String... apiVersions);
    public Boolean hasApiVersions();
    public A addNewApiVersion(String arg1);
    public A addNewApiVersion(StringBuilder arg1);
    public A addNewApiVersion(StringBuffer arg1);
    public A addToOperations(int index,String item);
    public A setToOperations(int index,String item);
    public A addToOperations(String... items);
    public A addAllToOperations(Collection<String> items);
    public A removeFromOperations(String... items);
    public A removeAllFromOperations(Collection<String> items);
    public List<String> getOperations();
    public String getOperation(int index);
    public String getFirstOperation();
    public String getLastOperation();
    public String getMatchingOperation(io.kubernetes.client.fluent.Predicate<String> predicate);
    public Boolean hasMatchingOperation(io.kubernetes.client.fluent.Predicate<String> predicate);
    public A withOperations(List<String> operations);
    public A withOperations(String... operations);
    public Boolean hasOperations();
    public A addNewOperation(String arg1);
    public A addNewOperation(StringBuilder arg1);
    public A addNewOperation(StringBuffer arg1);
    public A addToResources(int index,String item);
    public A setToResources(int index,String item);
    public A addToResources(String... items);
    public A addAllToResources(Collection<String> items);
    public A removeFromResources(String... items);
    public A removeAllFromResources(Collection<String> items);
    public List<String> getResources();
    public String getResource(int index);
    public String getFirstResource();
    public String getLastResource();
    public String getMatchingResource(io.kubernetes.client.fluent.Predicate<String> predicate);
    public Boolean hasMatchingResource(io.kubernetes.client.fluent.Predicate<String> predicate);
    public A withResources(List<String> resources);
    public A withResources(String... resources);
    public Boolean hasResources();
    public A addNewResource(String arg1);
    public A addNewResource(StringBuilder arg1);
    public A addNewResource(StringBuffer arg1);
    public String getScope();
    public A withScope(String scope);
    public Boolean hasScope();
    public A withNewScope(String arg1);
    public A withNewScope(StringBuilder arg1);
    public A withNewScope(StringBuffer arg1);
}
