package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1ResourceFieldSelectorBuilder extends V1ResourceFieldSelectorFluentImpl<V1ResourceFieldSelectorBuilder> implements VisitableBuilder<V1ResourceFieldSelector,V1ResourceFieldSelectorBuilder> {

    V1ResourceFieldSelectorFluent<?> fluent;
    Boolean validationEnabled;

    public V1ResourceFieldSelectorBuilder() { 
        this(true);
    }


    public V1ResourceFieldSelectorBuilder(Boolean validationEnabled) { 
        this(new V1ResourceFieldSelector(), validationEnabled);
    }


    public V1ResourceFieldSelectorBuilder(V1ResourceFieldSelectorFluent<?> fluent) { 
        this(fluent, true);
    }


    public V1ResourceFieldSelectorBuilder(V1ResourceFieldSelectorFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new V1ResourceFieldSelector(), validationEnabled);
    }


    public V1ResourceFieldSelectorBuilder(V1ResourceFieldSelectorFluent<?> fluent,V1ResourceFieldSelector instance) { 
        this(fluent, instance, true);
    }


    public V1ResourceFieldSelectorBuilder(V1ResourceFieldSelectorFluent<?> fluent,V1ResourceFieldSelector instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withContainerName(instance.getContainerName());

        fluent.withDivisor(instance.getDivisor());

        fluent.withResource(instance.getResource());

        this.validationEnabled = validationEnabled; 
    }


    public V1ResourceFieldSelectorBuilder(V1ResourceFieldSelector instance) { 
        this(instance,true);
    }


    public V1ResourceFieldSelectorBuilder(V1ResourceFieldSelector instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withContainerName(instance.getContainerName());

        this.withDivisor(instance.getDivisor());

        this.withResource(instance.getResource());

        this.validationEnabled = validationEnabled; 
    }


    public V1ResourceFieldSelector build() {
        V1ResourceFieldSelector buildable = new V1ResourceFieldSelector();
        buildable.setContainerName(fluent.getContainerName());
        buildable.setDivisor(fluent.getDivisor());
        buildable.setResource(fluent.getResource());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        V1ResourceFieldSelectorBuilder that = (V1ResourceFieldSelectorBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
