package io.kubernetes.client.openapi.models;

import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.kubernetes.client.fluent.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class V1RBDPersistentVolumeSourceFluentImpl<A extends V1RBDPersistentVolumeSourceFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1RBDPersistentVolumeSourceFluent<A> {

    private String fsType;
    private String image;
    private String keyring;
    private List<String> monitors;
    private String pool;
    private Boolean readOnly;
    private V1SecretReferenceBuilder secretRef;
    private String user;

    public V1RBDPersistentVolumeSourceFluentImpl() { 
    }


    public V1RBDPersistentVolumeSourceFluentImpl(V1RBDPersistentVolumeSource instance) { 
        this.withFsType(instance.getFsType());

        this.withImage(instance.getImage());

        this.withKeyring(instance.getKeyring());

        this.withMonitors(instance.getMonitors());

        this.withPool(instance.getPool());

        this.withReadOnly(instance.getReadOnly());

        this.withSecretRef(instance.getSecretRef());

        this.withUser(instance.getUser());

    }


    public String getFsType() {
        return this.fsType;
    }

    public A withFsType(String fsType) {
        this.fsType=fsType; return (A) this;
    }

    public Boolean hasFsType() {
        return this.fsType != null;
    }

    public A withNewFsType(String arg1) {
        return (A)withFsType(new String(arg1));
    }

    public A withNewFsType(StringBuilder arg1) {
        return (A)withFsType(new String(arg1));
    }

    public A withNewFsType(StringBuffer arg1) {
        return (A)withFsType(new String(arg1));
    }

    public String getImage() {
        return this.image;
    }

    public A withImage(String image) {
        this.image=image; return (A) this;
    }

    public Boolean hasImage() {
        return this.image != null;
    }

    public A withNewImage(String arg1) {
        return (A)withImage(new String(arg1));
    }

    public A withNewImage(StringBuilder arg1) {
        return (A)withImage(new String(arg1));
    }

    public A withNewImage(StringBuffer arg1) {
        return (A)withImage(new String(arg1));
    }

    public String getKeyring() {
        return this.keyring;
    }

    public A withKeyring(String keyring) {
        this.keyring=keyring; return (A) this;
    }

    public Boolean hasKeyring() {
        return this.keyring != null;
    }

    public A withNewKeyring(String arg1) {
        return (A)withKeyring(new String(arg1));
    }

    public A withNewKeyring(StringBuilder arg1) {
        return (A)withKeyring(new String(arg1));
    }

    public A withNewKeyring(StringBuffer arg1) {
        return (A)withKeyring(new String(arg1));
    }

    public A addToMonitors(int index,String item) {
        if (this.monitors == null) {this.monitors = new ArrayList<String>();}
        this.monitors.add(index, item);
        return (A)this;
    }

    public A setToMonitors(int index,String item) {
        if (this.monitors == null) {this.monitors = new ArrayList<String>();}
        this.monitors.set(index, item); return (A)this;
    }

    public A addToMonitors(String... items) {
        if (this.monitors == null) {this.monitors = new ArrayList<String>();}
        for (String item : items) {this.monitors.add(item);} return (A)this;
    }

    public A addAllToMonitors(Collection<String> items) {
        if (this.monitors == null) {this.monitors = new ArrayList<String>();}
        for (String item : items) {this.monitors.add(item);} return (A)this;
    }

    public A removeFromMonitors(String... items) {
        for (String item : items) {if (this.monitors!= null){ this.monitors.remove(item);}} return (A)this;
    }

    public A removeAllFromMonitors(Collection<String> items) {
        for (String item : items) {if (this.monitors!= null){ this.monitors.remove(item);}} return (A)this;
    }

    public List<String> getMonitors() {
        return this.monitors;
    }

    public String getMonitor(int index) {
        return this.monitors.get(index);
    }

    public String getFirstMonitor() {
        return this.monitors.get(0);
    }

    public String getLastMonitor() {
        return this.monitors.get(monitors.size() - 1);
    }

    public String getMatchingMonitor(io.kubernetes.client.fluent.Predicate<String> predicate) {
        for (String item: monitors) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingMonitor(io.kubernetes.client.fluent.Predicate<String> predicate) {
        for (String item: monitors) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withMonitors(List<String> monitors) {
        if (this.monitors != null) { _visitables.get("monitors").removeAll(this.monitors);}
        if (monitors != null) {this.monitors = new ArrayList<String>(); for (String item : monitors){this.addToMonitors(item);}} else { this.monitors = null;} return (A) this;
    }

    public A withMonitors(String... monitors) {
        if (this.monitors != null) {this.monitors.clear();}
        if (monitors != null) {for (String item :monitors){ this.addToMonitors(item);}} return (A) this;
    }

    public Boolean hasMonitors() {
        return monitors != null && !monitors.isEmpty();
    }

    public A addNewMonitor(String arg1) {
        return (A)addToMonitors(new String(arg1));
    }

    public A addNewMonitor(StringBuilder arg1) {
        return (A)addToMonitors(new String(arg1));
    }

    public A addNewMonitor(StringBuffer arg1) {
        return (A)addToMonitors(new String(arg1));
    }

    public String getPool() {
        return this.pool;
    }

    public A withPool(String pool) {
        this.pool=pool; return (A) this;
    }

    public Boolean hasPool() {
        return this.pool != null;
    }

    public A withNewPool(String arg1) {
        return (A)withPool(new String(arg1));
    }

    public A withNewPool(StringBuilder arg1) {
        return (A)withPool(new String(arg1));
    }

    public A withNewPool(StringBuffer arg1) {
        return (A)withPool(new String(arg1));
    }

    public Boolean isReadOnly() {
        return this.readOnly;
    }

    public A withReadOnly(Boolean readOnly) {
        this.readOnly=readOnly; return (A) this;
    }

    public Boolean hasReadOnly() {
        return this.readOnly != null;
    }

    public A withNewReadOnly(String arg1) {
        return (A)withReadOnly(new Boolean(arg1));
    }

    public A withNewReadOnly(boolean arg1) {
        return (A)withReadOnly(new Boolean(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildSecretRef instead.
 * @return The buildable object.
 */
@Deprecated public V1SecretReference getSecretRef() {
        return this.secretRef!=null?this.secretRef.build():null;
    }

    public V1SecretReference buildSecretRef() {
        return this.secretRef!=null?this.secretRef.build():null;
    }

    public A withSecretRef(V1SecretReference secretRef) {
        _visitables.get("secretRef").remove(this.secretRef);
        if (secretRef!=null){ this.secretRef= new V1SecretReferenceBuilder(secretRef); _visitables.get("secretRef").add(this.secretRef);} return (A) this;
    }

    public Boolean hasSecretRef() {
        return this.secretRef != null;
    }

    public V1RBDPersistentVolumeSourceFluent.SecretRefNested<A> withNewSecretRef() {
        return new SecretRefNestedImpl();
    }

    public V1RBDPersistentVolumeSourceFluent.SecretRefNested<A> withNewSecretRefLike(V1SecretReference item) {
        return new SecretRefNestedImpl(item);
    }

    public V1RBDPersistentVolumeSourceFluent.SecretRefNested<A> editSecretRef() {
        return withNewSecretRefLike(getSecretRef());
    }

    public V1RBDPersistentVolumeSourceFluent.SecretRefNested<A> editOrNewSecretRef() {
        return withNewSecretRefLike(getSecretRef() != null ? getSecretRef(): new V1SecretReferenceBuilder().build());
    }

    public V1RBDPersistentVolumeSourceFluent.SecretRefNested<A> editOrNewSecretRefLike(V1SecretReference item) {
        return withNewSecretRefLike(getSecretRef() != null ? getSecretRef(): item);
    }

    public String getUser() {
        return this.user;
    }

    public A withUser(String user) {
        this.user=user; return (A) this;
    }

    public Boolean hasUser() {
        return this.user != null;
    }

    public A withNewUser(String arg1) {
        return (A)withUser(new String(arg1));
    }

    public A withNewUser(StringBuilder arg1) {
        return (A)withUser(new String(arg1));
    }

    public A withNewUser(StringBuffer arg1) {
        return (A)withUser(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        V1RBDPersistentVolumeSourceFluentImpl that = (V1RBDPersistentVolumeSourceFluentImpl) o;
        if (fsType != null ? !fsType.equals(that.fsType) :that.fsType != null) return false;
        if (image != null ? !image.equals(that.image) :that.image != null) return false;
        if (keyring != null ? !keyring.equals(that.keyring) :that.keyring != null) return false;
        if (monitors != null ? !monitors.equals(that.monitors) :that.monitors != null) return false;
        if (pool != null ? !pool.equals(that.pool) :that.pool != null) return false;
        if (readOnly != null ? !readOnly.equals(that.readOnly) :that.readOnly != null) return false;
        if (secretRef != null ? !secretRef.equals(that.secretRef) :that.secretRef != null) return false;
        if (user != null ? !user.equals(that.user) :that.user != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fsType,  image,  keyring,  monitors,  pool,  readOnly,  secretRef,  user,  super.hashCode());
    }

    public class SecretRefNestedImpl<N> extends V1SecretReferenceFluentImpl<V1RBDPersistentVolumeSourceFluent.SecretRefNested<N>> implements V1RBDPersistentVolumeSourceFluent.SecretRefNested<N>,io.kubernetes.client.fluent.Nested<N> {
        private final V1SecretReferenceBuilder builder;

        SecretRefNestedImpl(V1SecretReference item) {
            this.builder = new V1SecretReferenceBuilder(this, item);
        }

        SecretRefNestedImpl() {
            this.builder = new V1SecretReferenceBuilder(this);
        }

        public N and() {
             return (N) V1RBDPersistentVolumeSourceFluentImpl.this.withSecretRef(builder.build());
        }

        public N endSecretRef() {
             return and();
        }
    }


}
