package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1PhotonPersistentDiskVolumeSourceBuilder extends V1PhotonPersistentDiskVolumeSourceFluentImpl<V1PhotonPersistentDiskVolumeSourceBuilder> implements VisitableBuilder<V1PhotonPersistentDiskVolumeSource,V1PhotonPersistentDiskVolumeSourceBuilder> {

    V1PhotonPersistentDiskVolumeSourceFluent<?> fluent;
    Boolean validationEnabled;

    public V1PhotonPersistentDiskVolumeSourceBuilder() { 
        this(true);
    }


    public V1PhotonPersistentDiskVolumeSourceBuilder(Boolean validationEnabled) { 
        this(new V1PhotonPersistentDiskVolumeSource(), validationEnabled);
    }


    public V1PhotonPersistentDiskVolumeSourceBuilder(V1PhotonPersistentDiskVolumeSourceFluent<?> fluent) { 
        this(fluent, true);
    }


    public V1PhotonPersistentDiskVolumeSourceBuilder(V1PhotonPersistentDiskVolumeSourceFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new V1PhotonPersistentDiskVolumeSource(), validationEnabled);
    }


    public V1PhotonPersistentDiskVolumeSourceBuilder(V1PhotonPersistentDiskVolumeSourceFluent<?> fluent,V1PhotonPersistentDiskVolumeSource instance) { 
        this(fluent, instance, true);
    }


    public V1PhotonPersistentDiskVolumeSourceBuilder(V1PhotonPersistentDiskVolumeSourceFluent<?> fluent,V1PhotonPersistentDiskVolumeSource instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withFsType(instance.getFsType());

        fluent.withPdID(instance.getPdID());

        this.validationEnabled = validationEnabled; 
    }


    public V1PhotonPersistentDiskVolumeSourceBuilder(V1PhotonPersistentDiskVolumeSource instance) { 
        this(instance,true);
    }


    public V1PhotonPersistentDiskVolumeSourceBuilder(V1PhotonPersistentDiskVolumeSource instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withFsType(instance.getFsType());

        this.withPdID(instance.getPdID());

        this.validationEnabled = validationEnabled; 
    }


    public V1PhotonPersistentDiskVolumeSource build() {
        V1PhotonPersistentDiskVolumeSource buildable = new V1PhotonPersistentDiskVolumeSource();
        buildable.setFsType(fluent.getFsType());
        buildable.setPdID(fluent.getPdID());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        V1PhotonPersistentDiskVolumeSourceBuilder that = (V1PhotonPersistentDiskVolumeSourceBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
