package io.kubernetes.client.openapi.models;

import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.kubernetes.client.fluent.Predicate;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;

public class V1PersistentVolumeClaimSpecFluentImpl<A extends V1PersistentVolumeClaimSpecFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1PersistentVolumeClaimSpecFluent<A> {

    private List<String> accessModes;
    private V1TypedLocalObjectReferenceBuilder dataSource;
    private V1ResourceRequirementsBuilder resources;
    private V1LabelSelectorBuilder selector;
    private String storageClassName;
    private String volumeMode;
    private String volumeName;

    public V1PersistentVolumeClaimSpecFluentImpl() { 
    }


    public V1PersistentVolumeClaimSpecFluentImpl(V1PersistentVolumeClaimSpec instance) { 
        this.withAccessModes(instance.getAccessModes());

        this.withDataSource(instance.getDataSource());

        this.withResources(instance.getResources());

        this.withSelector(instance.getSelector());

        this.withStorageClassName(instance.getStorageClassName());

        this.withVolumeMode(instance.getVolumeMode());

        this.withVolumeName(instance.getVolumeName());

    }


    public A addToAccessModes(int index,String item) {
        if (this.accessModes == null) {this.accessModes = new ArrayList<String>();}
        this.accessModes.add(index, item);
        return (A)this;
    }

    public A setToAccessModes(int index,String item) {
        if (this.accessModes == null) {this.accessModes = new ArrayList<String>();}
        this.accessModes.set(index, item); return (A)this;
    }

    public A addToAccessModes(String... items) {
        if (this.accessModes == null) {this.accessModes = new ArrayList<String>();}
        for (String item : items) {this.accessModes.add(item);} return (A)this;
    }

    public A addAllToAccessModes(Collection<String> items) {
        if (this.accessModes == null) {this.accessModes = new ArrayList<String>();}
        for (String item : items) {this.accessModes.add(item);} return (A)this;
    }

    public A removeFromAccessModes(String... items) {
        for (String item : items) {if (this.accessModes!= null){ this.accessModes.remove(item);}} return (A)this;
    }

    public A removeAllFromAccessModes(Collection<String> items) {
        for (String item : items) {if (this.accessModes!= null){ this.accessModes.remove(item);}} return (A)this;
    }

    public List<String> getAccessModes() {
        return this.accessModes;
    }

    public String getAccessMode(int index) {
        return this.accessModes.get(index);
    }

    public String getFirstAccessMode() {
        return this.accessModes.get(0);
    }

    public String getLastAccessMode() {
        return this.accessModes.get(accessModes.size() - 1);
    }

    public String getMatchingAccessMode(io.kubernetes.client.fluent.Predicate<String> predicate) {
        for (String item: accessModes) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingAccessMode(io.kubernetes.client.fluent.Predicate<String> predicate) {
        for (String item: accessModes) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withAccessModes(List<String> accessModes) {
        if (this.accessModes != null) { _visitables.get("accessModes").removeAll(this.accessModes);}
        if (accessModes != null) {this.accessModes = new ArrayList<String>(); for (String item : accessModes){this.addToAccessModes(item);}} else { this.accessModes = null;} return (A) this;
    }

    public A withAccessModes(String... accessModes) {
        if (this.accessModes != null) {this.accessModes.clear();}
        if (accessModes != null) {for (String item :accessModes){ this.addToAccessModes(item);}} return (A) this;
    }

    public Boolean hasAccessModes() {
        return accessModes != null && !accessModes.isEmpty();
    }

    public A addNewAccessMode(String arg1) {
        return (A)addToAccessModes(new String(arg1));
    }

    public A addNewAccessMode(StringBuilder arg1) {
        return (A)addToAccessModes(new String(arg1));
    }

    public A addNewAccessMode(StringBuffer arg1) {
        return (A)addToAccessModes(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildDataSource instead.
 * @return The buildable object.
 */
@Deprecated public V1TypedLocalObjectReference getDataSource() {
        return this.dataSource!=null?this.dataSource.build():null;
    }

    public V1TypedLocalObjectReference buildDataSource() {
        return this.dataSource!=null?this.dataSource.build():null;
    }

    public A withDataSource(V1TypedLocalObjectReference dataSource) {
        _visitables.get("dataSource").remove(this.dataSource);
        if (dataSource!=null){ this.dataSource= new V1TypedLocalObjectReferenceBuilder(dataSource); _visitables.get("dataSource").add(this.dataSource);} return (A) this;
    }

    public Boolean hasDataSource() {
        return this.dataSource != null;
    }

    public V1PersistentVolumeClaimSpecFluent.DataSourceNested<A> withNewDataSource() {
        return new DataSourceNestedImpl();
    }

    public V1PersistentVolumeClaimSpecFluent.DataSourceNested<A> withNewDataSourceLike(V1TypedLocalObjectReference item) {
        return new DataSourceNestedImpl(item);
    }

    public V1PersistentVolumeClaimSpecFluent.DataSourceNested<A> editDataSource() {
        return withNewDataSourceLike(getDataSource());
    }

    public V1PersistentVolumeClaimSpecFluent.DataSourceNested<A> editOrNewDataSource() {
        return withNewDataSourceLike(getDataSource() != null ? getDataSource(): new V1TypedLocalObjectReferenceBuilder().build());
    }

    public V1PersistentVolumeClaimSpecFluent.DataSourceNested<A> editOrNewDataSourceLike(V1TypedLocalObjectReference item) {
        return withNewDataSourceLike(getDataSource() != null ? getDataSource(): item);
    }

    
/**
 * This method has been deprecated, please use method buildResources instead.
 * @return The buildable object.
 */
@Deprecated public V1ResourceRequirements getResources() {
        return this.resources!=null?this.resources.build():null;
    }

    public V1ResourceRequirements buildResources() {
        return this.resources!=null?this.resources.build():null;
    }

    public A withResources(V1ResourceRequirements resources) {
        _visitables.get("resources").remove(this.resources);
        if (resources!=null){ this.resources= new V1ResourceRequirementsBuilder(resources); _visitables.get("resources").add(this.resources);} return (A) this;
    }

    public Boolean hasResources() {
        return this.resources != null;
    }

    public V1PersistentVolumeClaimSpecFluent.ResourcesNested<A> withNewResources() {
        return new ResourcesNestedImpl();
    }

    public V1PersistentVolumeClaimSpecFluent.ResourcesNested<A> withNewResourcesLike(V1ResourceRequirements item) {
        return new ResourcesNestedImpl(item);
    }

    public V1PersistentVolumeClaimSpecFluent.ResourcesNested<A> editResources() {
        return withNewResourcesLike(getResources());
    }

    public V1PersistentVolumeClaimSpecFluent.ResourcesNested<A> editOrNewResources() {
        return withNewResourcesLike(getResources() != null ? getResources(): new V1ResourceRequirementsBuilder().build());
    }

    public V1PersistentVolumeClaimSpecFluent.ResourcesNested<A> editOrNewResourcesLike(V1ResourceRequirements item) {
        return withNewResourcesLike(getResources() != null ? getResources(): item);
    }

    
/**
 * This method has been deprecated, please use method buildSelector instead.
 * @return The buildable object.
 */
@Deprecated public V1LabelSelector getSelector() {
        return this.selector!=null?this.selector.build():null;
    }

    public V1LabelSelector buildSelector() {
        return this.selector!=null?this.selector.build():null;
    }

    public A withSelector(V1LabelSelector selector) {
        _visitables.get("selector").remove(this.selector);
        if (selector!=null){ this.selector= new V1LabelSelectorBuilder(selector); _visitables.get("selector").add(this.selector);} return (A) this;
    }

    public Boolean hasSelector() {
        return this.selector != null;
    }

    public V1PersistentVolumeClaimSpecFluent.SelectorNested<A> withNewSelector() {
        return new SelectorNestedImpl();
    }

    public V1PersistentVolumeClaimSpecFluent.SelectorNested<A> withNewSelectorLike(V1LabelSelector item) {
        return new SelectorNestedImpl(item);
    }

    public V1PersistentVolumeClaimSpecFluent.SelectorNested<A> editSelector() {
        return withNewSelectorLike(getSelector());
    }

    public V1PersistentVolumeClaimSpecFluent.SelectorNested<A> editOrNewSelector() {
        return withNewSelectorLike(getSelector() != null ? getSelector(): new V1LabelSelectorBuilder().build());
    }

    public V1PersistentVolumeClaimSpecFluent.SelectorNested<A> editOrNewSelectorLike(V1LabelSelector item) {
        return withNewSelectorLike(getSelector() != null ? getSelector(): item);
    }

    public String getStorageClassName() {
        return this.storageClassName;
    }

    public A withStorageClassName(String storageClassName) {
        this.storageClassName=storageClassName; return (A) this;
    }

    public Boolean hasStorageClassName() {
        return this.storageClassName != null;
    }

    public A withNewStorageClassName(String arg1) {
        return (A)withStorageClassName(new String(arg1));
    }

    public A withNewStorageClassName(StringBuilder arg1) {
        return (A)withStorageClassName(new String(arg1));
    }

    public A withNewStorageClassName(StringBuffer arg1) {
        return (A)withStorageClassName(new String(arg1));
    }

    public String getVolumeMode() {
        return this.volumeMode;
    }

    public A withVolumeMode(String volumeMode) {
        this.volumeMode=volumeMode; return (A) this;
    }

    public Boolean hasVolumeMode() {
        return this.volumeMode != null;
    }

    public A withNewVolumeMode(String arg1) {
        return (A)withVolumeMode(new String(arg1));
    }

    public A withNewVolumeMode(StringBuilder arg1) {
        return (A)withVolumeMode(new String(arg1));
    }

    public A withNewVolumeMode(StringBuffer arg1) {
        return (A)withVolumeMode(new String(arg1));
    }

    public String getVolumeName() {
        return this.volumeName;
    }

    public A withVolumeName(String volumeName) {
        this.volumeName=volumeName; return (A) this;
    }

    public Boolean hasVolumeName() {
        return this.volumeName != null;
    }

    public A withNewVolumeName(String arg1) {
        return (A)withVolumeName(new String(arg1));
    }

    public A withNewVolumeName(StringBuilder arg1) {
        return (A)withVolumeName(new String(arg1));
    }

    public A withNewVolumeName(StringBuffer arg1) {
        return (A)withVolumeName(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        V1PersistentVolumeClaimSpecFluentImpl that = (V1PersistentVolumeClaimSpecFluentImpl) o;
        if (accessModes != null ? !accessModes.equals(that.accessModes) :that.accessModes != null) return false;
        if (dataSource != null ? !dataSource.equals(that.dataSource) :that.dataSource != null) return false;
        if (resources != null ? !resources.equals(that.resources) :that.resources != null) return false;
        if (selector != null ? !selector.equals(that.selector) :that.selector != null) return false;
        if (storageClassName != null ? !storageClassName.equals(that.storageClassName) :that.storageClassName != null) return false;
        if (volumeMode != null ? !volumeMode.equals(that.volumeMode) :that.volumeMode != null) return false;
        if (volumeName != null ? !volumeName.equals(that.volumeName) :that.volumeName != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(accessModes,  dataSource,  resources,  selector,  storageClassName,  volumeMode,  volumeName,  super.hashCode());
    }

    public class DataSourceNestedImpl<N> extends V1TypedLocalObjectReferenceFluentImpl<V1PersistentVolumeClaimSpecFluent.DataSourceNested<N>> implements V1PersistentVolumeClaimSpecFluent.DataSourceNested<N>,io.kubernetes.client.fluent.Nested<N> {
        private final V1TypedLocalObjectReferenceBuilder builder;

        DataSourceNestedImpl(V1TypedLocalObjectReference item) {
            this.builder = new V1TypedLocalObjectReferenceBuilder(this, item);
        }

        DataSourceNestedImpl() {
            this.builder = new V1TypedLocalObjectReferenceBuilder(this);
        }

        public N and() {
             return (N) V1PersistentVolumeClaimSpecFluentImpl.this.withDataSource(builder.build());
        }

        public N endDataSource() {
             return and();
        }
    }


    public class ResourcesNestedImpl<N> extends V1ResourceRequirementsFluentImpl<V1PersistentVolumeClaimSpecFluent.ResourcesNested<N>> implements V1PersistentVolumeClaimSpecFluent.ResourcesNested<N>,io.kubernetes.client.fluent.Nested<N> {
        private final V1ResourceRequirementsBuilder builder;

        ResourcesNestedImpl(V1ResourceRequirements item) {
            this.builder = new V1ResourceRequirementsBuilder(this, item);
        }

        ResourcesNestedImpl() {
            this.builder = new V1ResourceRequirementsBuilder(this);
        }

        public N and() {
             return (N) V1PersistentVolumeClaimSpecFluentImpl.this.withResources(builder.build());
        }

        public N endResources() {
             return and();
        }
    }


    public class SelectorNestedImpl<N> extends V1LabelSelectorFluentImpl<V1PersistentVolumeClaimSpecFluent.SelectorNested<N>> implements V1PersistentVolumeClaimSpecFluent.SelectorNested<N>,io.kubernetes.client.fluent.Nested<N> {
        private final V1LabelSelectorBuilder builder;

        SelectorNestedImpl(V1LabelSelector item) {
            this.builder = new V1LabelSelectorBuilder(this, item);
        }

        SelectorNestedImpl() {
            this.builder = new V1LabelSelectorBuilder(this);
        }

        public N and() {
             return (N) V1PersistentVolumeClaimSpecFluentImpl.this.withSelector(builder.build());
        }

        public N endSelector() {
             return and();
        }
    }


}
