package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1NodeSelectorRequirementBuilder extends V1NodeSelectorRequirementFluentImpl<V1NodeSelectorRequirementBuilder> implements VisitableBuilder<V1NodeSelectorRequirement,V1NodeSelectorRequirementBuilder> {

    V1NodeSelectorRequirementFluent<?> fluent;
    Boolean validationEnabled;

    public V1NodeSelectorRequirementBuilder() { 
        this(true);
    }


    public V1NodeSelectorRequirementBuilder(Boolean validationEnabled) { 
        this(new V1NodeSelectorRequirement(), validationEnabled);
    }


    public V1NodeSelectorRequirementBuilder(V1NodeSelectorRequirementFluent<?> fluent) { 
        this(fluent, true);
    }


    public V1NodeSelectorRequirementBuilder(V1NodeSelectorRequirementFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new V1NodeSelectorRequirement(), validationEnabled);
    }


    public V1NodeSelectorRequirementBuilder(V1NodeSelectorRequirementFluent<?> fluent,V1NodeSelectorRequirement instance) { 
        this(fluent, instance, true);
    }


    public V1NodeSelectorRequirementBuilder(V1NodeSelectorRequirementFluent<?> fluent,V1NodeSelectorRequirement instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withKey(instance.getKey());

        fluent.withOperator(instance.getOperator());

        fluent.withValues(instance.getValues());

        this.validationEnabled = validationEnabled; 
    }


    public V1NodeSelectorRequirementBuilder(V1NodeSelectorRequirement instance) { 
        this(instance,true);
    }


    public V1NodeSelectorRequirementBuilder(V1NodeSelectorRequirement instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withKey(instance.getKey());

        this.withOperator(instance.getOperator());

        this.withValues(instance.getValues());

        this.validationEnabled = validationEnabled; 
    }


    public V1NodeSelectorRequirement build() {
        V1NodeSelectorRequirement buildable = new V1NodeSelectorRequirement();
        buildable.setKey(fluent.getKey());
        buildable.setOperator(fluent.getOperator());
        buildable.setValues(fluent.getValues());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        V1NodeSelectorRequirementBuilder that = (V1NodeSelectorRequirementBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
