package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1CustomResourceValidationBuilder extends V1CustomResourceValidationFluentImpl<V1CustomResourceValidationBuilder> implements VisitableBuilder<V1CustomResourceValidation,V1CustomResourceValidationBuilder> {

    V1CustomResourceValidationFluent<?> fluent;
    Boolean validationEnabled;

    public V1CustomResourceValidationBuilder() { 
        this(true);
    }


    public V1CustomResourceValidationBuilder(Boolean validationEnabled) { 
        this(new V1CustomResourceValidation(), validationEnabled);
    }


    public V1CustomResourceValidationBuilder(V1CustomResourceValidationFluent<?> fluent) { 
        this(fluent, true);
    }


    public V1CustomResourceValidationBuilder(V1CustomResourceValidationFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new V1CustomResourceValidation(), validationEnabled);
    }


    public V1CustomResourceValidationBuilder(V1CustomResourceValidationFluent<?> fluent,V1CustomResourceValidation instance) { 
        this(fluent, instance, true);
    }


    public V1CustomResourceValidationBuilder(V1CustomResourceValidationFluent<?> fluent,V1CustomResourceValidation instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withOpenAPIV3Schema(instance.getOpenAPIV3Schema());

        this.validationEnabled = validationEnabled; 
    }


    public V1CustomResourceValidationBuilder(V1CustomResourceValidation instance) { 
        this(instance,true);
    }


    public V1CustomResourceValidationBuilder(V1CustomResourceValidation instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withOpenAPIV3Schema(instance.getOpenAPIV3Schema());

        this.validationEnabled = validationEnabled; 
    }


    public V1CustomResourceValidation build() {
        V1CustomResourceValidation buildable = new V1CustomResourceValidation();
        buildable.setOpenAPIV3Schema(fluent.getOpenAPIV3Schema());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        V1CustomResourceValidationBuilder that = (V1CustomResourceValidationBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
