package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1AffinityBuilder extends V1AffinityFluentImpl<V1AffinityBuilder> implements VisitableBuilder<V1Affinity,V1AffinityBuilder> {

    V1AffinityFluent<?> fluent;
    Boolean validationEnabled;

    public V1AffinityBuilder() { 
        this(true);
    }


    public V1AffinityBuilder(Boolean validationEnabled) { 
        this(new V1Affinity(), validationEnabled);
    }


    public V1AffinityBuilder(V1AffinityFluent<?> fluent) { 
        this(fluent, true);
    }


    public V1AffinityBuilder(V1AffinityFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new V1Affinity(), validationEnabled);
    }


    public V1AffinityBuilder(V1AffinityFluent<?> fluent,V1Affinity instance) { 
        this(fluent, instance, true);
    }


    public V1AffinityBuilder(V1AffinityFluent<?> fluent,V1Affinity instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withNodeAffinity(instance.getNodeAffinity());

        fluent.withPodAffinity(instance.getPodAffinity());

        fluent.withPodAntiAffinity(instance.getPodAntiAffinity());

        this.validationEnabled = validationEnabled; 
    }


    public V1AffinityBuilder(V1Affinity instance) { 
        this(instance,true);
    }


    public V1AffinityBuilder(V1Affinity instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withNodeAffinity(instance.getNodeAffinity());

        this.withPodAffinity(instance.getPodAffinity());

        this.withPodAntiAffinity(instance.getPodAntiAffinity());

        this.validationEnabled = validationEnabled; 
    }


    public V1Affinity build() {
        V1Affinity buildable = new V1Affinity();
        buildable.setNodeAffinity(fluent.getNodeAffinity());
        buildable.setPodAffinity(fluent.getPodAffinity());
        buildable.setPodAntiAffinity(fluent.getPodAntiAffinity());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        V1AffinityBuilder that = (V1AffinityBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
