package io.kubernetes.client.openapi.models;

import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.lang.String;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.lang.Boolean;
import java.lang.StringBuffer;
import java.lang.Object;

public class FlowcontrolV1alpha1SubjectFluentImpl<A extends FlowcontrolV1alpha1SubjectFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements FlowcontrolV1alpha1SubjectFluent<A> {

    private V1alpha1GroupSubjectBuilder group;
    private String kind;
    private V1alpha1ServiceAccountSubjectBuilder serviceAccount;
    private V1alpha1UserSubjectBuilder user;

    public FlowcontrolV1alpha1SubjectFluentImpl() { 
    }


    public FlowcontrolV1alpha1SubjectFluentImpl(FlowcontrolV1alpha1Subject instance) { 
        this.withGroup(instance.getGroup());

        this.withKind(instance.getKind());

        this.withServiceAccount(instance.getServiceAccount());

        this.withUser(instance.getUser());

    }


    
/**
 * This method has been deprecated, please use method buildGroup instead.
 * @return The buildable object.
 */
@Deprecated public V1alpha1GroupSubject getGroup() {
        return this.group!=null?this.group.build():null;
    }

    public V1alpha1GroupSubject buildGroup() {
        return this.group!=null?this.group.build():null;
    }

    public A withGroup(V1alpha1GroupSubject group) {
        _visitables.get("group").remove(this.group);
        if (group!=null){ this.group= new V1alpha1GroupSubjectBuilder(group); _visitables.get("group").add(this.group);} return (A) this;
    }

    public Boolean hasGroup() {
        return this.group != null;
    }

    public FlowcontrolV1alpha1SubjectFluent.GroupNested<A> withNewGroup() {
        return new GroupNestedImpl();
    }

    public FlowcontrolV1alpha1SubjectFluent.GroupNested<A> withNewGroupLike(V1alpha1GroupSubject item) {
        return new GroupNestedImpl(item);
    }

    public FlowcontrolV1alpha1SubjectFluent.GroupNested<A> editGroup() {
        return withNewGroupLike(getGroup());
    }

    public FlowcontrolV1alpha1SubjectFluent.GroupNested<A> editOrNewGroup() {
        return withNewGroupLike(getGroup() != null ? getGroup(): new V1alpha1GroupSubjectBuilder().build());
    }

    public FlowcontrolV1alpha1SubjectFluent.GroupNested<A> editOrNewGroupLike(V1alpha1GroupSubject item) {
        return withNewGroupLike(getGroup() != null ? getGroup(): item);
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind=kind; return (A) this;
    }

    public Boolean hasKind() {
        return this.kind != null;
    }

    public A withNewKind(String arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuilder arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuffer arg1) {
        return (A)withKind(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildServiceAccount instead.
 * @return The buildable object.
 */
@Deprecated public V1alpha1ServiceAccountSubject getServiceAccount() {
        return this.serviceAccount!=null?this.serviceAccount.build():null;
    }

    public V1alpha1ServiceAccountSubject buildServiceAccount() {
        return this.serviceAccount!=null?this.serviceAccount.build():null;
    }

    public A withServiceAccount(V1alpha1ServiceAccountSubject serviceAccount) {
        _visitables.get("serviceAccount").remove(this.serviceAccount);
        if (serviceAccount!=null){ this.serviceAccount= new V1alpha1ServiceAccountSubjectBuilder(serviceAccount); _visitables.get("serviceAccount").add(this.serviceAccount);} return (A) this;
    }

    public Boolean hasServiceAccount() {
        return this.serviceAccount != null;
    }

    public FlowcontrolV1alpha1SubjectFluent.ServiceAccountNested<A> withNewServiceAccount() {
        return new ServiceAccountNestedImpl();
    }

    public FlowcontrolV1alpha1SubjectFluent.ServiceAccountNested<A> withNewServiceAccountLike(V1alpha1ServiceAccountSubject item) {
        return new ServiceAccountNestedImpl(item);
    }

    public FlowcontrolV1alpha1SubjectFluent.ServiceAccountNested<A> editServiceAccount() {
        return withNewServiceAccountLike(getServiceAccount());
    }

    public FlowcontrolV1alpha1SubjectFluent.ServiceAccountNested<A> editOrNewServiceAccount() {
        return withNewServiceAccountLike(getServiceAccount() != null ? getServiceAccount(): new V1alpha1ServiceAccountSubjectBuilder().build());
    }

    public FlowcontrolV1alpha1SubjectFluent.ServiceAccountNested<A> editOrNewServiceAccountLike(V1alpha1ServiceAccountSubject item) {
        return withNewServiceAccountLike(getServiceAccount() != null ? getServiceAccount(): item);
    }

    
/**
 * This method has been deprecated, please use method buildUser instead.
 * @return The buildable object.
 */
@Deprecated public V1alpha1UserSubject getUser() {
        return this.user!=null?this.user.build():null;
    }

    public V1alpha1UserSubject buildUser() {
        return this.user!=null?this.user.build():null;
    }

    public A withUser(V1alpha1UserSubject user) {
        _visitables.get("user").remove(this.user);
        if (user!=null){ this.user= new V1alpha1UserSubjectBuilder(user); _visitables.get("user").add(this.user);} return (A) this;
    }

    public Boolean hasUser() {
        return this.user != null;
    }

    public FlowcontrolV1alpha1SubjectFluent.UserNested<A> withNewUser() {
        return new UserNestedImpl();
    }

    public FlowcontrolV1alpha1SubjectFluent.UserNested<A> withNewUserLike(V1alpha1UserSubject item) {
        return new UserNestedImpl(item);
    }

    public FlowcontrolV1alpha1SubjectFluent.UserNested<A> editUser() {
        return withNewUserLike(getUser());
    }

    public FlowcontrolV1alpha1SubjectFluent.UserNested<A> editOrNewUser() {
        return withNewUserLike(getUser() != null ? getUser(): new V1alpha1UserSubjectBuilder().build());
    }

    public FlowcontrolV1alpha1SubjectFluent.UserNested<A> editOrNewUserLike(V1alpha1UserSubject item) {
        return withNewUserLike(getUser() != null ? getUser(): item);
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        FlowcontrolV1alpha1SubjectFluentImpl that = (FlowcontrolV1alpha1SubjectFluentImpl) o;
        if (group != null ? !group.equals(that.group) :that.group != null) return false;
        if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
        if (serviceAccount != null ? !serviceAccount.equals(that.serviceAccount) :that.serviceAccount != null) return false;
        if (user != null ? !user.equals(that.user) :that.user != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(group,  kind,  serviceAccount,  user,  super.hashCode());
    }

    public class GroupNestedImpl<N> extends V1alpha1GroupSubjectFluentImpl<FlowcontrolV1alpha1SubjectFluent.GroupNested<N>> implements FlowcontrolV1alpha1SubjectFluent.GroupNested<N>,io.kubernetes.client.fluent.Nested<N> {
        private final V1alpha1GroupSubjectBuilder builder;

        GroupNestedImpl(V1alpha1GroupSubject item) {
            this.builder = new V1alpha1GroupSubjectBuilder(this, item);
        }

        GroupNestedImpl() {
            this.builder = new V1alpha1GroupSubjectBuilder(this);
        }

        public N and() {
             return (N) FlowcontrolV1alpha1SubjectFluentImpl.this.withGroup(builder.build());
        }

        public N endGroup() {
             return and();
        }
    }


    public class ServiceAccountNestedImpl<N> extends V1alpha1ServiceAccountSubjectFluentImpl<FlowcontrolV1alpha1SubjectFluent.ServiceAccountNested<N>> implements FlowcontrolV1alpha1SubjectFluent.ServiceAccountNested<N>,io.kubernetes.client.fluent.Nested<N> {
        private final V1alpha1ServiceAccountSubjectBuilder builder;

        ServiceAccountNestedImpl(V1alpha1ServiceAccountSubject item) {
            this.builder = new V1alpha1ServiceAccountSubjectBuilder(this, item);
        }

        ServiceAccountNestedImpl() {
            this.builder = new V1alpha1ServiceAccountSubjectBuilder(this);
        }

        public N and() {
             return (N) FlowcontrolV1alpha1SubjectFluentImpl.this.withServiceAccount(builder.build());
        }

        public N endServiceAccount() {
             return and();
        }
    }


    public class UserNestedImpl<N> extends V1alpha1UserSubjectFluentImpl<FlowcontrolV1alpha1SubjectFluent.UserNested<N>> implements FlowcontrolV1alpha1SubjectFluent.UserNested<N>,io.kubernetes.client.fluent.Nested<N> {
        private final V1alpha1UserSubjectBuilder builder;

        UserNestedImpl(V1alpha1UserSubject item) {
            this.builder = new V1alpha1UserSubjectBuilder(this, item);
        }

        UserNestedImpl() {
            this.builder = new V1alpha1UserSubjectBuilder(this);
        }

        public N and() {
             return (N) FlowcontrolV1alpha1SubjectFluentImpl.this.withUser(builder.build());
        }

        public N endUser() {
             return and();
        }
    }


}
