package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class EventsV1EventSeriesBuilder extends EventsV1EventSeriesFluentImpl<EventsV1EventSeriesBuilder> implements VisitableBuilder<EventsV1EventSeries,EventsV1EventSeriesBuilder> {

    EventsV1EventSeriesFluent<?> fluent;
    Boolean validationEnabled;

    public EventsV1EventSeriesBuilder() { 
        this(true);
    }


    public EventsV1EventSeriesBuilder(Boolean validationEnabled) { 
        this(new EventsV1EventSeries(), validationEnabled);
    }


    public EventsV1EventSeriesBuilder(EventsV1EventSeriesFluent<?> fluent) { 
        this(fluent, true);
    }


    public EventsV1EventSeriesBuilder(EventsV1EventSeriesFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new EventsV1EventSeries(), validationEnabled);
    }


    public EventsV1EventSeriesBuilder(EventsV1EventSeriesFluent<?> fluent,EventsV1EventSeries instance) { 
        this(fluent, instance, true);
    }


    public EventsV1EventSeriesBuilder(EventsV1EventSeriesFluent<?> fluent,EventsV1EventSeries instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withCount(instance.getCount());

        fluent.withLastObservedTime(instance.getLastObservedTime());

        this.validationEnabled = validationEnabled; 
    }


    public EventsV1EventSeriesBuilder(EventsV1EventSeries instance) { 
        this(instance,true);
    }


    public EventsV1EventSeriesBuilder(EventsV1EventSeries instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withCount(instance.getCount());

        this.withLastObservedTime(instance.getLastObservedTime());

        this.validationEnabled = validationEnabled; 
    }


    public EventsV1EventSeries build() {
        EventsV1EventSeries buildable = new EventsV1EventSeries();
        buildable.setCount(fluent.getCount());
        buildable.setLastObservedTime(fluent.getLastObservedTime());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        EventsV1EventSeriesBuilder that = (EventsV1EventSeriesBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
