package io.kubernetes.client.openapi.models;

import java.lang.Integer;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import org.joda.time.DateTime;

public class CoreV1EventSeriesFluentImpl<A extends CoreV1EventSeriesFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements CoreV1EventSeriesFluent<A> {

    private Integer count;
    private DateTime lastObservedTime;

    public CoreV1EventSeriesFluentImpl() { 
    }


    public CoreV1EventSeriesFluentImpl(CoreV1EventSeries instance) { 
        this.withCount(instance.getCount());

        this.withLastObservedTime(instance.getLastObservedTime());

    }


    public Integer getCount() {
        return this.count;
    }

    public A withCount(Integer count) {
        this.count=count; return (A) this;
    }

    public Boolean hasCount() {
        return this.count != null;
    }

    public DateTime getLastObservedTime() {
        return this.lastObservedTime;
    }

    public A withLastObservedTime(DateTime lastObservedTime) {
        this.lastObservedTime=lastObservedTime; return (A) this;
    }

    public Boolean hasLastObservedTime() {
        return this.lastObservedTime != null;
    }

    public A withNewLastObservedTime(int arg0,int arg1,int arg2,int arg3,int arg4) {
        return (A)withLastObservedTime(new DateTime(arg0, arg1, arg2, arg3, arg4));
    }

    public A withNewLastObservedTime(Object arg0) {
        return (A)withLastObservedTime(new DateTime(arg0));
    }

    public A withNewLastObservedTime(long arg0) {
        return (A)withLastObservedTime(new DateTime(arg0));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        CoreV1EventSeriesFluentImpl that = (CoreV1EventSeriesFluentImpl) o;
        if (count != null ? !count.equals(that.count) :that.count != null) return false;
        if (lastObservedTime != null ? !lastObservedTime.equals(that.lastObservedTime) :that.lastObservedTime != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(count,  lastObservedTime,  super.hashCode());
    }

}
