/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import io.kubernetes.client.openapi.models.V1StorageClass;
import io.kubernetes.client.openapi.models.V1StorageClassFluent;
import io.kubernetes.client.openapi.models.V1StorageClassFluentImpl;

public class V1StorageClassBuilder
extends V1StorageClassFluentImpl<V1StorageClassBuilder>
implements VisitableBuilder<V1StorageClass, V1StorageClassBuilder> {
    V1StorageClassFluent<?> fluent;
    Boolean validationEnabled;

    public V1StorageClassBuilder() {
        this(true);
    }

    public V1StorageClassBuilder(Boolean validationEnabled) {
        this(new V1StorageClass(), validationEnabled);
    }

    public V1StorageClassBuilder(V1StorageClassFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public V1StorageClassBuilder(V1StorageClassFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new V1StorageClass(), validationEnabled);
    }

    public V1StorageClassBuilder(V1StorageClassFluent<?> fluent, V1StorageClass instance) {
        this(fluent, instance, true);
    }

    public V1StorageClassBuilder(V1StorageClassFluent<?> fluent, V1StorageClass instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withAllowVolumeExpansion(instance.getAllowVolumeExpansion());
        fluent.withAllowedTopologies(instance.getAllowedTopologies());
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withMountOptions(instance.getMountOptions());
        fluent.withParameters(instance.getParameters());
        fluent.withProvisioner(instance.getProvisioner());
        fluent.withReclaimPolicy(instance.getReclaimPolicy());
        fluent.withVolumeBindingMode(instance.getVolumeBindingMode());
        this.validationEnabled = validationEnabled;
    }

    public V1StorageClassBuilder(V1StorageClass instance) {
        this(instance, (Boolean)true);
    }

    public V1StorageClassBuilder(V1StorageClass instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withAllowVolumeExpansion(instance.getAllowVolumeExpansion());
        this.withAllowedTopologies(instance.getAllowedTopologies());
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withMountOptions(instance.getMountOptions());
        this.withParameters(instance.getParameters());
        this.withProvisioner(instance.getProvisioner());
        this.withReclaimPolicy(instance.getReclaimPolicy());
        this.withVolumeBindingMode(instance.getVolumeBindingMode());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public V1StorageClass build() {
        V1StorageClass buildable = new V1StorageClass();
        buildable.setAllowVolumeExpansion(this.fluent.isAllowVolumeExpansion());
        buildable.setAllowedTopologies(this.fluent.getAllowedTopologies());
        buildable.setApiVersion(this.fluent.getApiVersion());
        buildable.setKind(this.fluent.getKind());
        buildable.setMetadata(this.fluent.getMetadata());
        buildable.setMountOptions(this.fluent.getMountOptions());
        buildable.setParameters(this.fluent.getParameters());
        buildable.setProvisioner(this.fluent.getProvisioner());
        buildable.setReclaimPolicy(this.fluent.getReclaimPolicy());
        buildable.setVolumeBindingMode(this.fluent.getVolumeBindingMode());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1StorageClassBuilder that = (V1StorageClassBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

