/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;
import org.joda.time.DateTime;

@ApiModel(description="ManagedFieldsEntry is a workflow-id, a FieldSet and the group version of the resource that the fieldset applies to.")
public class V1ManagedFieldsEntry {
    public static final String SERIALIZED_NAME_API_VERSION = "apiVersion";
    @SerializedName(value="apiVersion")
    private String apiVersion;
    public static final String SERIALIZED_NAME_FIELDS_TYPE = "fieldsType";
    @SerializedName(value="fieldsType")
    private String fieldsType;
    public static final String SERIALIZED_NAME_FIELDS_V1 = "fieldsV1";
    @SerializedName(value="fieldsV1")
    private Object fieldsV1;
    public static final String SERIALIZED_NAME_MANAGER = "manager";
    @SerializedName(value="manager")
    private String manager;
    public static final String SERIALIZED_NAME_OPERATION = "operation";
    @SerializedName(value="operation")
    private String operation;
    public static final String SERIALIZED_NAME_TIME = "time";
    @SerializedName(value="time")
    private DateTime time;

    public V1ManagedFieldsEntry apiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="APIVersion defines the version of this resource that this field set applies to. The format is \"group/version\" just like the top-level APIVersion field. It is necessary to track the version of a field set because it cannot be automatically converted.")
    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public V1ManagedFieldsEntry fieldsType(String fieldsType) {
        this.fieldsType = fieldsType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="FieldsType is the discriminator for the different fields format and version. There is currently only one possible value: \"FieldsV1\"")
    public String getFieldsType() {
        return this.fieldsType;
    }

    public void setFieldsType(String fieldsType) {
        this.fieldsType = fieldsType;
    }

    public V1ManagedFieldsEntry fieldsV1(Object fieldsV1) {
        this.fieldsV1 = fieldsV1;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="FieldsV1 holds the first JSON version format as described in the \"FieldsV1\" type.")
    public Object getFieldsV1() {
        return this.fieldsV1;
    }

    public void setFieldsV1(Object fieldsV1) {
        this.fieldsV1 = fieldsV1;
    }

    public V1ManagedFieldsEntry manager(String manager) {
        this.manager = manager;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Manager is an identifier of the workflow managing these fields.")
    public String getManager() {
        return this.manager;
    }

    public void setManager(String manager) {
        this.manager = manager;
    }

    public V1ManagedFieldsEntry operation(String operation) {
        this.operation = operation;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Operation is the type of operation which lead to this ManagedFieldsEntry being created. The only valid values for this field are 'Apply' and 'Update'.")
    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public V1ManagedFieldsEntry time(DateTime time) {
        this.time = time;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Time is timestamp of when these fields were set. It should always be empty if Operation is 'Apply'")
    public DateTime getTime() {
        return this.time;
    }

    public void setTime(DateTime time) {
        this.time = time;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1ManagedFieldsEntry v1ManagedFieldsEntry = (V1ManagedFieldsEntry)o;
        return Objects.equals(this.apiVersion, v1ManagedFieldsEntry.apiVersion) && Objects.equals(this.fieldsType, v1ManagedFieldsEntry.fieldsType) && Objects.equals(this.fieldsV1, v1ManagedFieldsEntry.fieldsV1) && Objects.equals(this.manager, v1ManagedFieldsEntry.manager) && Objects.equals(this.operation, v1ManagedFieldsEntry.operation) && Objects.equals(this.time, v1ManagedFieldsEntry.time);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.fieldsType, this.fieldsV1, this.manager, this.operation, this.time);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1ManagedFieldsEntry {\n");
        sb.append("    apiVersion: ").append(this.toIndentedString(this.apiVersion)).append("\n");
        sb.append("    fieldsType: ").append(this.toIndentedString(this.fieldsType)).append("\n");
        sb.append("    fieldsV1: ").append(this.toIndentedString(this.fieldsV1)).append("\n");
        sb.append("    manager: ").append(this.toIndentedString(this.manager)).append("\n");
        sb.append("    operation: ").append(this.toIndentedString(this.operation)).append("\n");
        sb.append("    time: ").append(this.toIndentedString(this.time)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

