/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Represents a Glusterfs mount that lasts the lifetime of a pod. Glusterfs volumes do not support ownership management or SELinux relabeling.")
public class V1GlusterfsPersistentVolumeSource {
    public static final String SERIALIZED_NAME_ENDPOINTS = "endpoints";
    @SerializedName(value="endpoints")
    private String endpoints;
    public static final String SERIALIZED_NAME_ENDPOINTS_NAMESPACE = "endpointsNamespace";
    @SerializedName(value="endpointsNamespace")
    private String endpointsNamespace;
    public static final String SERIALIZED_NAME_PATH = "path";
    @SerializedName(value="path")
    private String path;
    public static final String SERIALIZED_NAME_READ_ONLY = "readOnly";
    @SerializedName(value="readOnly")
    private Boolean readOnly;

    public V1GlusterfsPersistentVolumeSource endpoints(String endpoints) {
        this.endpoints = endpoints;
        return this;
    }

    @ApiModelProperty(required=true, value="EndpointsName is the endpoint name that details Glusterfs topology. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod")
    public String getEndpoints() {
        return this.endpoints;
    }

    public void setEndpoints(String endpoints) {
        this.endpoints = endpoints;
    }

    public V1GlusterfsPersistentVolumeSource endpointsNamespace(String endpointsNamespace) {
        this.endpointsNamespace = endpointsNamespace;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="EndpointsNamespace is the namespace that contains Glusterfs endpoint. If this field is empty, the EndpointNamespace defaults to the same namespace as the bound PVC. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod")
    public String getEndpointsNamespace() {
        return this.endpointsNamespace;
    }

    public void setEndpointsNamespace(String endpointsNamespace) {
        this.endpointsNamespace = endpointsNamespace;
    }

    public V1GlusterfsPersistentVolumeSource path(String path) {
        this.path = path;
        return this;
    }

    @ApiModelProperty(required=true, value="Path is the Glusterfs volume path. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod")
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public V1GlusterfsPersistentVolumeSource readOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ReadOnly here will force the Glusterfs volume to be mounted with read-only permissions. Defaults to false. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod")
    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1GlusterfsPersistentVolumeSource v1GlusterfsPersistentVolumeSource = (V1GlusterfsPersistentVolumeSource)o;
        return Objects.equals(this.endpoints, v1GlusterfsPersistentVolumeSource.endpoints) && Objects.equals(this.endpointsNamespace, v1GlusterfsPersistentVolumeSource.endpointsNamespace) && Objects.equals(this.path, v1GlusterfsPersistentVolumeSource.path) && Objects.equals(this.readOnly, v1GlusterfsPersistentVolumeSource.readOnly);
    }

    public int hashCode() {
        return Objects.hash(this.endpoints, this.endpointsNamespace, this.path, this.readOnly);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1GlusterfsPersistentVolumeSource {\n");
        sb.append("    endpoints: ").append(this.toIndentedString(this.endpoints)).append("\n");
        sb.append("    endpointsNamespace: ").append(this.toIndentedString(this.endpointsNamespace)).append("\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("    readOnly: ").append(this.toIndentedString(this.readOnly)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

