/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="IPBlock describes a particular CIDR (Ex. \"192.168.1.1/24\") that is allowed to the pods matched by a NetworkPolicySpec's podSelector. The except entry describes CIDRs that should not be included within this rule.")
public class V1beta1IPBlock {
    @SerializedName(value="cidr")
    private String cidr = null;
    @SerializedName(value="except")
    private List<String> except = null;

    public V1beta1IPBlock cidr(String cidr) {
        this.cidr = cidr;
        return this;
    }

    @ApiModelProperty(required=true, value="CIDR is a string representing the IP Block Valid examples are \"192.168.1.1/24\"")
    public String getCidr() {
        return this.cidr;
    }

    public void setCidr(String cidr) {
        this.cidr = cidr;
    }

    public V1beta1IPBlock except(List<String> except) {
        this.except = except;
        return this;
    }

    public V1beta1IPBlock addExceptItem(String exceptItem) {
        if (this.except == null) {
            this.except = new ArrayList<String>();
        }
        this.except.add(exceptItem);
        return this;
    }

    @ApiModelProperty(value="Except is a slice of CIDRs that should not be included within an IP Block Valid examples are \"192.168.1.1/24\" Except values will be rejected if they are outside the CIDR range")
    public List<String> getExcept() {
        return this.except;
    }

    public void setExcept(List<String> except) {
        this.except = except;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1beta1IPBlock v1beta1IPBlock = (V1beta1IPBlock)o;
        return Objects.equals(this.cidr, v1beta1IPBlock.cidr) && Objects.equals(this.except, v1beta1IPBlock.except);
    }

    public int hashCode() {
        return Objects.hash(this.cidr, this.except);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1beta1IPBlock {\n");
        sb.append("    cidr: ").append(this.toIndentedString(this.cidr)).append("\n");
        sb.append("    except: ").append(this.toIndentedString(this.except)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

