/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.models.V1NonResourceAttributes;
import io.kubernetes.client.models.V1ResourceAttributes;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="SubjectAccessReviewSpec is a description of the access request.  Exactly one of ResourceAuthorizationAttributes and NonResourceAuthorizationAttributes must be set")
public class V1SubjectAccessReviewSpec {
    @SerializedName(value="extra")
    private Map<String, List<String>> extra = null;
    @SerializedName(value="groups")
    private List<String> groups = null;
    @SerializedName(value="nonResourceAttributes")
    private V1NonResourceAttributes nonResourceAttributes = null;
    @SerializedName(value="resourceAttributes")
    private V1ResourceAttributes resourceAttributes = null;
    @SerializedName(value="uid")
    private String uid = null;
    @SerializedName(value="user")
    private String user = null;

    public V1SubjectAccessReviewSpec extra(Map<String, List<String>> extra) {
        this.extra = extra;
        return this;
    }

    public V1SubjectAccessReviewSpec putExtraItem(String key, List<String> extraItem) {
        if (this.extra == null) {
            this.extra = new HashMap<String, List<String>>();
        }
        this.extra.put(key, extraItem);
        return this;
    }

    @ApiModelProperty(value="Extra corresponds to the user.Info.GetExtra() method from the authenticator.  Since that is input to the authorizer it needs a reflection here.")
    public Map<String, List<String>> getExtra() {
        return this.extra;
    }

    public void setExtra(Map<String, List<String>> extra) {
        this.extra = extra;
    }

    public V1SubjectAccessReviewSpec groups(List<String> groups) {
        this.groups = groups;
        return this;
    }

    public V1SubjectAccessReviewSpec addGroupsItem(String groupsItem) {
        if (this.groups == null) {
            this.groups = new ArrayList<String>();
        }
        this.groups.add(groupsItem);
        return this;
    }

    @ApiModelProperty(value="Groups is the groups you're testing for.")
    public List<String> getGroups() {
        return this.groups;
    }

    public void setGroups(List<String> groups) {
        this.groups = groups;
    }

    public V1SubjectAccessReviewSpec nonResourceAttributes(V1NonResourceAttributes nonResourceAttributes) {
        this.nonResourceAttributes = nonResourceAttributes;
        return this;
    }

    @ApiModelProperty(value="NonResourceAttributes describes information for a non-resource access request")
    public V1NonResourceAttributes getNonResourceAttributes() {
        return this.nonResourceAttributes;
    }

    public void setNonResourceAttributes(V1NonResourceAttributes nonResourceAttributes) {
        this.nonResourceAttributes = nonResourceAttributes;
    }

    public V1SubjectAccessReviewSpec resourceAttributes(V1ResourceAttributes resourceAttributes) {
        this.resourceAttributes = resourceAttributes;
        return this;
    }

    @ApiModelProperty(value="ResourceAuthorizationAttributes describes information for a resource access request")
    public V1ResourceAttributes getResourceAttributes() {
        return this.resourceAttributes;
    }

    public void setResourceAttributes(V1ResourceAttributes resourceAttributes) {
        this.resourceAttributes = resourceAttributes;
    }

    public V1SubjectAccessReviewSpec uid(String uid) {
        this.uid = uid;
        return this;
    }

    @ApiModelProperty(value="UID information about the requesting user.")
    public String getUid() {
        return this.uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public V1SubjectAccessReviewSpec user(String user) {
        this.user = user;
        return this;
    }

    @ApiModelProperty(value="User is the user you're testing for. If you specify \"User\" but not \"Groups\", then is it interpreted as \"What if User were not a member of any groups")
    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1SubjectAccessReviewSpec v1SubjectAccessReviewSpec = (V1SubjectAccessReviewSpec)o;
        return Objects.equals(this.extra, v1SubjectAccessReviewSpec.extra) && Objects.equals(this.groups, v1SubjectAccessReviewSpec.groups) && Objects.equals(this.nonResourceAttributes, v1SubjectAccessReviewSpec.nonResourceAttributes) && Objects.equals(this.resourceAttributes, v1SubjectAccessReviewSpec.resourceAttributes) && Objects.equals(this.uid, v1SubjectAccessReviewSpec.uid) && Objects.equals(this.user, v1SubjectAccessReviewSpec.user);
    }

    public int hashCode() {
        return Objects.hash(this.extra, this.groups, this.nonResourceAttributes, this.resourceAttributes, this.uid, this.user);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1SubjectAccessReviewSpec {\n");
        sb.append("    extra: ").append(this.toIndentedString(this.extra)).append("\n");
        sb.append("    groups: ").append(this.toIndentedString(this.groups)).append("\n");
        sb.append("    nonResourceAttributes: ").append(this.toIndentedString(this.nonResourceAttributes)).append("\n");
        sb.append("    resourceAttributes: ").append(this.toIndentedString(this.resourceAttributes)).append("\n");
        sb.append("    uid: ").append(this.toIndentedString(this.uid)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

