/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="GroupVersion contains the \"group/version\" and \"version\" string of a version. It is made a struct to keep extensibility.")
public class V1GroupVersionForDiscovery {
    @SerializedName(value="groupVersion")
    private String groupVersion = null;
    @SerializedName(value="version")
    private String version = null;

    public V1GroupVersionForDiscovery groupVersion(String groupVersion) {
        this.groupVersion = groupVersion;
        return this;
    }

    @ApiModelProperty(required=true, value="groupVersion specifies the API group and version in the form \"group/version\"")
    public String getGroupVersion() {
        return this.groupVersion;
    }

    public void setGroupVersion(String groupVersion) {
        this.groupVersion = groupVersion;
    }

    public V1GroupVersionForDiscovery version(String version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(required=true, value="version specifies the version in the form of \"version\". This is to save the clients the trouble of splitting the GroupVersion.")
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1GroupVersionForDiscovery v1GroupVersionForDiscovery = (V1GroupVersionForDiscovery)o;
        return Objects.equals(this.groupVersion, v1GroupVersionForDiscovery.groupVersion) && Objects.equals(this.version, v1GroupVersionForDiscovery.version);
    }

    public int hashCode() {
        return Objects.hash(this.groupVersion, this.version);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1GroupVersionForDiscovery {\n");
        sb.append("    groupVersion: ").append(this.toIndentedString(this.groupVersion)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

