/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.models.V1LabelSelector;
import io.kubernetes.client.models.V1ResourceRequirements;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="PersistentVolumeClaimSpec describes the common attributes of storage devices and allows a Source for provider-specific attributes")
public class V1PersistentVolumeClaimSpec {
    @SerializedName(value="accessModes")
    private List<String> accessModes = null;
    @SerializedName(value="resources")
    private V1ResourceRequirements resources = null;
    @SerializedName(value="selector")
    private V1LabelSelector selector = null;
    @SerializedName(value="storageClassName")
    private String storageClassName = null;
    @SerializedName(value="volumeName")
    private String volumeName = null;

    public V1PersistentVolumeClaimSpec accessModes(List<String> accessModes) {
        this.accessModes = accessModes;
        return this;
    }

    public V1PersistentVolumeClaimSpec addAccessModesItem(String accessModesItem) {
        if (this.accessModes == null) {
            this.accessModes = new ArrayList<String>();
        }
        this.accessModes.add(accessModesItem);
        return this;
    }

    @ApiModelProperty(value="AccessModes contains the desired access modes the volume should have. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes-1")
    public List<String> getAccessModes() {
        return this.accessModes;
    }

    public void setAccessModes(List<String> accessModes) {
        this.accessModes = accessModes;
    }

    public V1PersistentVolumeClaimSpec resources(V1ResourceRequirements resources) {
        this.resources = resources;
        return this;
    }

    @ApiModelProperty(value="Resources represents the minimum resources the volume should have. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#resources")
    public V1ResourceRequirements getResources() {
        return this.resources;
    }

    public void setResources(V1ResourceRequirements resources) {
        this.resources = resources;
    }

    public V1PersistentVolumeClaimSpec selector(V1LabelSelector selector) {
        this.selector = selector;
        return this;
    }

    @ApiModelProperty(value="A label query over volumes to consider for binding.")
    public V1LabelSelector getSelector() {
        return this.selector;
    }

    public void setSelector(V1LabelSelector selector) {
        this.selector = selector;
    }

    public V1PersistentVolumeClaimSpec storageClassName(String storageClassName) {
        this.storageClassName = storageClassName;
        return this;
    }

    @ApiModelProperty(value="Name of the StorageClass required by the claim. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#class-1")
    public String getStorageClassName() {
        return this.storageClassName;
    }

    public void setStorageClassName(String storageClassName) {
        this.storageClassName = storageClassName;
    }

    public V1PersistentVolumeClaimSpec volumeName(String volumeName) {
        this.volumeName = volumeName;
        return this;
    }

    @ApiModelProperty(value="VolumeName is the binding reference to the PersistentVolume backing this claim.")
    public String getVolumeName() {
        return this.volumeName;
    }

    public void setVolumeName(String volumeName) {
        this.volumeName = volumeName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1PersistentVolumeClaimSpec v1PersistentVolumeClaimSpec = (V1PersistentVolumeClaimSpec)o;
        return Objects.equals(this.accessModes, v1PersistentVolumeClaimSpec.accessModes) && Objects.equals(this.resources, v1PersistentVolumeClaimSpec.resources) && Objects.equals(this.selector, v1PersistentVolumeClaimSpec.selector) && Objects.equals(this.storageClassName, v1PersistentVolumeClaimSpec.storageClassName) && Objects.equals(this.volumeName, v1PersistentVolumeClaimSpec.volumeName);
    }

    public int hashCode() {
        return Objects.hash(this.accessModes, this.resources, this.selector, this.storageClassName, this.volumeName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1PersistentVolumeClaimSpec {\n");
        sb.append("    accessModes: ").append(this.toIndentedString(this.accessModes)).append("\n");
        sb.append("    resources: ").append(this.toIndentedString(this.resources)).append("\n");
        sb.append("    selector: ").append(this.toIndentedString(this.selector)).append("\n");
        sb.append("    storageClassName: ").append(this.toIndentedString(this.storageClassName)).append("\n");
        sb.append("    volumeName: ").append(this.toIndentedString(this.volumeName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

