/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.models.V2alpha1ObjectMetricSource;
import io.kubernetes.client.models.V2alpha1PodsMetricSource;
import io.kubernetes.client.models.V2alpha1ResourceMetricSource;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="MetricSpec specifies how to scale based on a single metric (only `type` and one other matching field should be set at once).")
public class V2alpha1MetricSpec {
    @SerializedName(value="object")
    private V2alpha1ObjectMetricSource object = null;
    @SerializedName(value="pods")
    private V2alpha1PodsMetricSource pods = null;
    @SerializedName(value="resource")
    private V2alpha1ResourceMetricSource resource = null;
    @SerializedName(value="type")
    private String type = null;

    public V2alpha1MetricSpec object(V2alpha1ObjectMetricSource object) {
        this.object = object;
        return this;
    }

    @ApiModelProperty(value="object refers to a metric describing a single kubernetes object (for example, hits-per-second on an Ingress object).")
    public V2alpha1ObjectMetricSource getObject() {
        return this.object;
    }

    public void setObject(V2alpha1ObjectMetricSource object) {
        this.object = object;
    }

    public V2alpha1MetricSpec pods(V2alpha1PodsMetricSource pods) {
        this.pods = pods;
        return this;
    }

    @ApiModelProperty(value="pods refers to a metric describing each pod in the current scale target (for example, transactions-processed-per-second).  The values will be averaged together before being compared to the target value.")
    public V2alpha1PodsMetricSource getPods() {
        return this.pods;
    }

    public void setPods(V2alpha1PodsMetricSource pods) {
        this.pods = pods;
    }

    public V2alpha1MetricSpec resource(V2alpha1ResourceMetricSource resource) {
        this.resource = resource;
        return this;
    }

    @ApiModelProperty(value="resource refers to a resource metric (such as those specified in requests and limits) known to Kubernetes describing each pod in the current scale target (e.g. CPU or memory). Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the \"pods\" source.")
    public V2alpha1ResourceMetricSource getResource() {
        return this.resource;
    }

    public void setResource(V2alpha1ResourceMetricSource resource) {
        this.resource = resource;
    }

    public V2alpha1MetricSpec type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="type is the type of metric source.  It should match one of the fields below.")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V2alpha1MetricSpec v2alpha1MetricSpec = (V2alpha1MetricSpec)o;
        return Objects.equals(this.object, v2alpha1MetricSpec.object) && Objects.equals(this.pods, v2alpha1MetricSpec.pods) && Objects.equals(this.resource, v2alpha1MetricSpec.resource) && Objects.equals(this.type, v2alpha1MetricSpec.type);
    }

    public int hashCode() {
        return Objects.hash(this.object, this.pods, this.resource, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V2alpha1MetricSpec {\n");
        sb.append("    object: ").append(this.toIndentedString(this.object)).append("\n");
        sb.append("    pods: ").append(this.toIndentedString(this.pods)).append("\n");
        sb.append("    resource: ").append(this.toIndentedString(this.resource)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

