/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.models.V1ListMeta;
import io.kubernetes.client.models.V2alpha1HorizontalPodAutoscaler;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="HorizontalPodAutoscaler is a list of horizontal pod autoscaler objects.")
public class V2alpha1HorizontalPodAutoscalerList {
    @SerializedName(value="apiVersion")
    private String apiVersion = null;
    @SerializedName(value="items")
    private List<V2alpha1HorizontalPodAutoscaler> items = new ArrayList<V2alpha1HorizontalPodAutoscaler>();
    @SerializedName(value="kind")
    private String kind = null;
    @SerializedName(value="metadata")
    private V1ListMeta metadata = null;

    public V2alpha1HorizontalPodAutoscalerList apiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    @ApiModelProperty(value="APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources")
    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public V2alpha1HorizontalPodAutoscalerList items(List<V2alpha1HorizontalPodAutoscaler> items) {
        this.items = items;
        return this;
    }

    public V2alpha1HorizontalPodAutoscalerList addItemsItem(V2alpha1HorizontalPodAutoscaler itemsItem) {
        this.items.add(itemsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="items is the list of horizontal pod autoscaler objects.")
    public List<V2alpha1HorizontalPodAutoscaler> getItems() {
        return this.items;
    }

    public void setItems(List<V2alpha1HorizontalPodAutoscaler> items) {
        this.items = items;
    }

    public V2alpha1HorizontalPodAutoscalerList kind(String kind) {
        this.kind = kind;
        return this;
    }

    @ApiModelProperty(value="Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds")
    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public V2alpha1HorizontalPodAutoscalerList metadata(V1ListMeta metadata) {
        this.metadata = metadata;
        return this;
    }

    @ApiModelProperty(value="metadata is the standard list metadata.")
    public V1ListMeta getMetadata() {
        return this.metadata;
    }

    public void setMetadata(V1ListMeta metadata) {
        this.metadata = metadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V2alpha1HorizontalPodAutoscalerList v2alpha1HorizontalPodAutoscalerList = (V2alpha1HorizontalPodAutoscalerList)o;
        return Objects.equals(this.apiVersion, v2alpha1HorizontalPodAutoscalerList.apiVersion) && Objects.equals(this.items, v2alpha1HorizontalPodAutoscalerList.items) && Objects.equals(this.kind, v2alpha1HorizontalPodAutoscalerList.kind) && Objects.equals(this.metadata, v2alpha1HorizontalPodAutoscalerList.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.items, this.kind, this.metadata);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V2alpha1HorizontalPodAutoscalerList {\n");
        sb.append("    apiVersion: ").append(this.toIndentedString(this.apiVersion)).append("\n");
        sb.append("    items: ").append(this.toIndentedString(this.items)).append("\n");
        sb.append("    kind: ").append(this.toIndentedString(this.kind)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

