/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.models.V1EventSource;
import io.kubernetes.client.models.V1ObjectMeta;
import io.kubernetes.client.models.V1ObjectReference;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import org.joda.time.DateTime;

@ApiModel(description="Event is a report of an event somewhere in the cluster.")
public class V1Event {
    @SerializedName(value="apiVersion")
    private String apiVersion = null;
    @SerializedName(value="count")
    private Integer count = null;
    @SerializedName(value="firstTimestamp")
    private DateTime firstTimestamp = null;
    @SerializedName(value="involvedObject")
    private V1ObjectReference involvedObject = null;
    @SerializedName(value="kind")
    private String kind = null;
    @SerializedName(value="lastTimestamp")
    private DateTime lastTimestamp = null;
    @SerializedName(value="message")
    private String message = null;
    @SerializedName(value="metadata")
    private V1ObjectMeta metadata = null;
    @SerializedName(value="reason")
    private String reason = null;
    @SerializedName(value="source")
    private V1EventSource source = null;
    @SerializedName(value="type")
    private String type = null;

    public V1Event apiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    @ApiModelProperty(value="APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources")
    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public V1Event count(Integer count) {
        this.count = count;
        return this;
    }

    @ApiModelProperty(value="The number of times this event has occurred.")
    public Integer getCount() {
        return this.count;
    }

    public void setCount(Integer count) {
        this.count = count;
    }

    public V1Event firstTimestamp(DateTime firstTimestamp) {
        this.firstTimestamp = firstTimestamp;
        return this;
    }

    @ApiModelProperty(value="The time at which the event was first recorded. (Time of server receipt is in TypeMeta.)")
    public DateTime getFirstTimestamp() {
        return this.firstTimestamp;
    }

    public void setFirstTimestamp(DateTime firstTimestamp) {
        this.firstTimestamp = firstTimestamp;
    }

    public V1Event involvedObject(V1ObjectReference involvedObject) {
        this.involvedObject = involvedObject;
        return this;
    }

    @ApiModelProperty(required=true, value="The object that this event is about.")
    public V1ObjectReference getInvolvedObject() {
        return this.involvedObject;
    }

    public void setInvolvedObject(V1ObjectReference involvedObject) {
        this.involvedObject = involvedObject;
    }

    public V1Event kind(String kind) {
        this.kind = kind;
        return this;
    }

    @ApiModelProperty(value="Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds")
    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public V1Event lastTimestamp(DateTime lastTimestamp) {
        this.lastTimestamp = lastTimestamp;
        return this;
    }

    @ApiModelProperty(value="The time at which the most recent occurrence of this event was recorded.")
    public DateTime getLastTimestamp() {
        return this.lastTimestamp;
    }

    public void setLastTimestamp(DateTime lastTimestamp) {
        this.lastTimestamp = lastTimestamp;
    }

    public V1Event message(String message) {
        this.message = message;
        return this;
    }

    @ApiModelProperty(value="A human-readable description of the status of this operation.")
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public V1Event metadata(V1ObjectMeta metadata) {
        this.metadata = metadata;
        return this;
    }

    @ApiModelProperty(required=true, value="Standard object's metadata. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#metadata")
    public V1ObjectMeta getMetadata() {
        return this.metadata;
    }

    public void setMetadata(V1ObjectMeta metadata) {
        this.metadata = metadata;
    }

    public V1Event reason(String reason) {
        this.reason = reason;
        return this;
    }

    @ApiModelProperty(value="This should be a short, machine understandable string that gives the reason for the transition into the object's current status.")
    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public V1Event source(V1EventSource source) {
        this.source = source;
        return this;
    }

    @ApiModelProperty(value="The component reporting this event. Should be a short machine understandable string.")
    public V1EventSource getSource() {
        return this.source;
    }

    public void setSource(V1EventSource source) {
        this.source = source;
    }

    public V1Event type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="Type of this event (Normal, Warning), new types could be added in the future")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1Event v1Event = (V1Event)o;
        return Objects.equals(this.apiVersion, v1Event.apiVersion) && Objects.equals(this.count, v1Event.count) && Objects.equals(this.firstTimestamp, v1Event.firstTimestamp) && Objects.equals(this.involvedObject, v1Event.involvedObject) && Objects.equals(this.kind, v1Event.kind) && Objects.equals(this.lastTimestamp, v1Event.lastTimestamp) && Objects.equals(this.message, v1Event.message) && Objects.equals(this.metadata, v1Event.metadata) && Objects.equals(this.reason, v1Event.reason) && Objects.equals(this.source, v1Event.source) && Objects.equals(this.type, v1Event.type);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.count, this.firstTimestamp, this.involvedObject, this.kind, this.lastTimestamp, this.message, this.metadata, this.reason, this.source, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1Event {\n");
        sb.append("    apiVersion: ").append(this.toIndentedString(this.apiVersion)).append("\n");
        sb.append("    count: ").append(this.toIndentedString(this.count)).append("\n");
        sb.append("    firstTimestamp: ").append(this.toIndentedString(this.firstTimestamp)).append("\n");
        sb.append("    involvedObject: ").append(this.toIndentedString(this.involvedObject)).append("\n");
        sb.append("    kind: ").append(this.toIndentedString(this.kind)).append("\n");
        sb.append("    lastTimestamp: ").append(this.toIndentedString(this.lastTimestamp)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    reason: ").append(this.toIndentedString(this.reason)).append("\n");
        sb.append("    source: ").append(this.toIndentedString(this.source)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

