/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Represents a cinder volume resource in Openstack. A Cinder volume must exist before mounting to a container. The volume must also be in the same region as the kubelet. Cinder volumes support ownership management and SELinux relabeling.")
public class V1CinderVolumeSource {
    @SerializedName(value="fsType")
    private String fsType = null;
    @SerializedName(value="readOnly")
    private Boolean readOnly = null;
    @SerializedName(value="volumeID")
    private String volumeID = null;

    public V1CinderVolumeSource fsType(String fsType) {
        this.fsType = fsType;
        return this;
    }

    @ApiModelProperty(value="Filesystem type to mount. Must be a filesystem type supported by the host operating system. Examples: \"ext4\", \"xfs\", \"ntfs\". Implicitly inferred to be \"ext4\" if unspecified. More info: http://releases.k8s.io/HEAD/examples/mysql-cinder-pd/README.md")
    public String getFsType() {
        return this.fsType;
    }

    public void setFsType(String fsType) {
        this.fsType = fsType;
    }

    public V1CinderVolumeSource readOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    @ApiModelProperty(value="Optional: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. More info: http://releases.k8s.io/HEAD/examples/mysql-cinder-pd/README.md")
    public Boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    public V1CinderVolumeSource volumeID(String volumeID) {
        this.volumeID = volumeID;
        return this;
    }

    @ApiModelProperty(required=true, value="volume id used to identify the volume in cinder More info: http://releases.k8s.io/HEAD/examples/mysql-cinder-pd/README.md")
    public String getVolumeID() {
        return this.volumeID;
    }

    public void setVolumeID(String volumeID) {
        this.volumeID = volumeID;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1CinderVolumeSource v1CinderVolumeSource = (V1CinderVolumeSource)o;
        return Objects.equals(this.fsType, v1CinderVolumeSource.fsType) && Objects.equals(this.readOnly, v1CinderVolumeSource.readOnly) && Objects.equals(this.volumeID, v1CinderVolumeSource.volumeID);
    }

    public int hashCode() {
        return Objects.hash(this.fsType, this.readOnly, this.volumeID);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1CinderVolumeSource {\n");
        sb.append("    fsType: ").append(this.toIndentedString(this.fsType)).append("\n");
        sb.append("    readOnly: ").append(this.toIndentedString(this.readOnly)).append("\n");
        sb.append("    volumeID: ").append(this.toIndentedString(this.volumeID)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

