/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="ScaleStatus represents the current status of a scale subresource.")
public class AppsV1beta1ScaleStatus {
    @SerializedName(value="replicas")
    private Integer replicas = null;
    @SerializedName(value="selector")
    private Map<String, String> selector = null;
    @SerializedName(value="targetSelector")
    private String targetSelector = null;

    public AppsV1beta1ScaleStatus replicas(Integer replicas) {
        this.replicas = replicas;
        return this;
    }

    @ApiModelProperty(required=true, value="actual number of observed instances of the scaled object.")
    public Integer getReplicas() {
        return this.replicas;
    }

    public void setReplicas(Integer replicas) {
        this.replicas = replicas;
    }

    public AppsV1beta1ScaleStatus selector(Map<String, String> selector) {
        this.selector = selector;
        return this;
    }

    public AppsV1beta1ScaleStatus putSelectorItem(String key, String selectorItem) {
        if (this.selector == null) {
            this.selector = new HashMap<String, String>();
        }
        this.selector.put(key, selectorItem);
        return this;
    }

    @ApiModelProperty(value="label query over pods that should match the replicas count. More info: http://kubernetes.io/docs/user-guide/labels#label-selectors")
    public Map<String, String> getSelector() {
        return this.selector;
    }

    public void setSelector(Map<String, String> selector) {
        this.selector = selector;
    }

    public AppsV1beta1ScaleStatus targetSelector(String targetSelector) {
        this.targetSelector = targetSelector;
        return this;
    }

    @ApiModelProperty(value="label selector for pods that should match the replicas count. This is a serializated version of both map-based and more expressive set-based selectors. This is done to avoid introspection in the clients. The string will be in the same format as the query-param syntax. If the target type only supports map-based selectors, both this field and map-based selector field are populated. More info: http://kubernetes.io/docs/user-guide/labels#label-selectors")
    public String getTargetSelector() {
        return this.targetSelector;
    }

    public void setTargetSelector(String targetSelector) {
        this.targetSelector = targetSelector;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AppsV1beta1ScaleStatus appsV1beta1ScaleStatus = (AppsV1beta1ScaleStatus)o;
        return Objects.equals(this.replicas, appsV1beta1ScaleStatus.replicas) && Objects.equals(this.selector, appsV1beta1ScaleStatus.selector) && Objects.equals(this.targetSelector, appsV1beta1ScaleStatus.targetSelector);
    }

    public int hashCode() {
        return Objects.hash(this.replicas, this.selector, this.targetSelector);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AppsV1beta1ScaleStatus {\n");
        sb.append("    replicas: ").append(this.toIndentedString(this.replicas)).append("\n");
        sb.append("    selector: ").append(this.toIndentedString(this.selector)).append("\n");
        sb.append("    targetSelector: ").append(this.toIndentedString(this.targetSelector)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

