/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.models.V1LabelSelector;
import io.kubernetes.client.models.V1PersistentVolumeClaim;
import io.kubernetes.client.models.V1PodTemplateSpec;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="A StatefulSetSpec is the specification of a StatefulSet.")
public class V1beta1StatefulSetSpec {
    @SerializedName(value="replicas")
    private Integer replicas = null;
    @SerializedName(value="selector")
    private V1LabelSelector selector = null;
    @SerializedName(value="serviceName")
    private String serviceName = null;
    @SerializedName(value="template")
    private V1PodTemplateSpec template = null;
    @SerializedName(value="volumeClaimTemplates")
    private List<V1PersistentVolumeClaim> volumeClaimTemplates = null;

    public V1beta1StatefulSetSpec replicas(Integer replicas) {
        this.replicas = replicas;
        return this;
    }

    @ApiModelProperty(value="Replicas is the desired number of replicas of the given Template. These are replicas in the sense that they are instantiations of the same Template, but individual replicas also have a consistent identity. If unspecified, defaults to 1.")
    public Integer getReplicas() {
        return this.replicas;
    }

    public void setReplicas(Integer replicas) {
        this.replicas = replicas;
    }

    public V1beta1StatefulSetSpec selector(V1LabelSelector selector) {
        this.selector = selector;
        return this;
    }

    @ApiModelProperty(value="Selector is a label query over pods that should match the replica count. If empty, defaulted to labels on the pod template. More info: http://kubernetes.io/docs/user-guide/labels#label-selectors")
    public V1LabelSelector getSelector() {
        return this.selector;
    }

    public void setSelector(V1LabelSelector selector) {
        this.selector = selector;
    }

    public V1beta1StatefulSetSpec serviceName(String serviceName) {
        this.serviceName = serviceName;
        return this;
    }

    @ApiModelProperty(required=true, value="ServiceName is the name of the service that governs this StatefulSet. This service must exist before the StatefulSet, and is responsible for the network identity of the set. Pods get DNS/hostnames that follow the pattern: pod-specific-string.serviceName.default.svc.cluster.local where \"pod-specific-string\" is managed by the StatefulSet controller.")
    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public V1beta1StatefulSetSpec template(V1PodTemplateSpec template) {
        this.template = template;
        return this;
    }

    @ApiModelProperty(required=true, value="Template is the object that describes the pod that will be created if insufficient replicas are detected. Each pod stamped out by the StatefulSet will fulfill this Template, but have a unique identity from the rest of the StatefulSet.")
    public V1PodTemplateSpec getTemplate() {
        return this.template;
    }

    public void setTemplate(V1PodTemplateSpec template) {
        this.template = template;
    }

    public V1beta1StatefulSetSpec volumeClaimTemplates(List<V1PersistentVolumeClaim> volumeClaimTemplates) {
        this.volumeClaimTemplates = volumeClaimTemplates;
        return this;
    }

    public V1beta1StatefulSetSpec addVolumeClaimTemplatesItem(V1PersistentVolumeClaim volumeClaimTemplatesItem) {
        if (this.volumeClaimTemplates == null) {
            this.volumeClaimTemplates = new ArrayList<V1PersistentVolumeClaim>();
        }
        this.volumeClaimTemplates.add(volumeClaimTemplatesItem);
        return this;
    }

    @ApiModelProperty(value="VolumeClaimTemplates is a list of claims that pods are allowed to reference. The StatefulSet controller is responsible for mapping network identities to claims in a way that maintains the identity of a pod. Every claim in this list must have at least one matching (by name) volumeMount in one container in the template. A claim in this list takes precedence over any volumes in the template, with the same name.")
    public List<V1PersistentVolumeClaim> getVolumeClaimTemplates() {
        return this.volumeClaimTemplates;
    }

    public void setVolumeClaimTemplates(List<V1PersistentVolumeClaim> volumeClaimTemplates) {
        this.volumeClaimTemplates = volumeClaimTemplates;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1beta1StatefulSetSpec v1beta1StatefulSetSpec = (V1beta1StatefulSetSpec)o;
        return Objects.equals(this.replicas, v1beta1StatefulSetSpec.replicas) && Objects.equals(this.selector, v1beta1StatefulSetSpec.selector) && Objects.equals(this.serviceName, v1beta1StatefulSetSpec.serviceName) && Objects.equals(this.template, v1beta1StatefulSetSpec.template) && Objects.equals(this.volumeClaimTemplates, v1beta1StatefulSetSpec.volumeClaimTemplates);
    }

    public int hashCode() {
        return Objects.hash(this.replicas, this.selector, this.serviceName, this.template, this.volumeClaimTemplates);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1beta1StatefulSetSpec {\n");
        sb.append("    replicas: ").append(this.toIndentedString(this.replicas)).append("\n");
        sb.append("    selector: ").append(this.toIndentedString(this.selector)).append("\n");
        sb.append("    serviceName: ").append(this.toIndentedString(this.serviceName)).append("\n");
        sb.append("    template: ").append(this.toIndentedString(this.template)).append("\n");
        sb.append("    volumeClaimTemplates: ").append(this.toIndentedString(this.volumeClaimTemplates)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

