/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.models.V1ObjectMeta;
import io.kubernetes.client.models.V1beta1PolicyRule;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Role is a namespaced, logical grouping of PolicyRules that can be referenced as a unit by a RoleBinding.")
public class V1beta1Role {
    @SerializedName(value="apiVersion")
    private String apiVersion = null;
    @SerializedName(value="kind")
    private String kind = null;
    @SerializedName(value="metadata")
    private V1ObjectMeta metadata = null;
    @SerializedName(value="rules")
    private List<V1beta1PolicyRule> rules = new ArrayList<V1beta1PolicyRule>();

    public V1beta1Role apiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    @ApiModelProperty(value="APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#resources")
    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public V1beta1Role kind(String kind) {
        this.kind = kind;
        return this;
    }

    @ApiModelProperty(value="Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: http://releases.k8s.io/HEAD/docs/devel/api-conventions.md#types-kinds")
    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public V1beta1Role metadata(V1ObjectMeta metadata) {
        this.metadata = metadata;
        return this;
    }

    @ApiModelProperty(value="Standard object's metadata.")
    public V1ObjectMeta getMetadata() {
        return this.metadata;
    }

    public void setMetadata(V1ObjectMeta metadata) {
        this.metadata = metadata;
    }

    public V1beta1Role rules(List<V1beta1PolicyRule> rules) {
        this.rules = rules;
        return this;
    }

    public V1beta1Role addRulesItem(V1beta1PolicyRule rulesItem) {
        this.rules.add(rulesItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Rules holds all the PolicyRules for this Role")
    public List<V1beta1PolicyRule> getRules() {
        return this.rules;
    }

    public void setRules(List<V1beta1PolicyRule> rules) {
        this.rules = rules;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1beta1Role v1beta1Role = (V1beta1Role)o;
        return Objects.equals(this.apiVersion, v1beta1Role.apiVersion) && Objects.equals(this.kind, v1beta1Role.kind) && Objects.equals(this.metadata, v1beta1Role.metadata) && Objects.equals(this.rules, v1beta1Role.rules);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.kind, this.metadata, this.rules);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1beta1Role {\n");
        sb.append("    apiVersion: ").append(this.toIndentedString(this.apiVersion)).append("\n");
        sb.append("    kind: ").append(this.toIndentedString(this.kind)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    rules: ").append(this.toIndentedString(this.rules)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

