/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Represents an ISCSI disk. ISCSI volumes can only be mounted as read/write once. ISCSI volumes support ownership management and SELinux relabeling.")
public class V1ISCSIVolumeSource {
    @SerializedName(value="fsType")
    private String fsType = null;
    @SerializedName(value="iqn")
    private String iqn = null;
    @SerializedName(value="iscsiInterface")
    private String iscsiInterface = null;
    @SerializedName(value="lun")
    private Integer lun = null;
    @SerializedName(value="portals")
    private List<String> portals = null;
    @SerializedName(value="readOnly")
    private Boolean readOnly = null;
    @SerializedName(value="targetPortal")
    private String targetPortal = null;

    public V1ISCSIVolumeSource fsType(String fsType) {
        this.fsType = fsType;
        return this;
    }

    @ApiModelProperty(value="Filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: \"ext4\", \"xfs\", \"ntfs\". Implicitly inferred to be \"ext4\" if unspecified. More info: http://kubernetes.io/docs/user-guide/volumes#iscsi")
    public String getFsType() {
        return this.fsType;
    }

    public void setFsType(String fsType) {
        this.fsType = fsType;
    }

    public V1ISCSIVolumeSource iqn(String iqn) {
        this.iqn = iqn;
        return this;
    }

    @ApiModelProperty(required=true, value="Target iSCSI Qualified Name.")
    public String getIqn() {
        return this.iqn;
    }

    public void setIqn(String iqn) {
        this.iqn = iqn;
    }

    public V1ISCSIVolumeSource iscsiInterface(String iscsiInterface) {
        this.iscsiInterface = iscsiInterface;
        return this;
    }

    @ApiModelProperty(value="Optional: Defaults to 'default' (tcp). iSCSI interface name that uses an iSCSI transport.")
    public String getIscsiInterface() {
        return this.iscsiInterface;
    }

    public void setIscsiInterface(String iscsiInterface) {
        this.iscsiInterface = iscsiInterface;
    }

    public V1ISCSIVolumeSource lun(Integer lun) {
        this.lun = lun;
        return this;
    }

    @ApiModelProperty(required=true, value="iSCSI target lun number.")
    public Integer getLun() {
        return this.lun;
    }

    public void setLun(Integer lun) {
        this.lun = lun;
    }

    public V1ISCSIVolumeSource portals(List<String> portals) {
        this.portals = portals;
        return this;
    }

    public V1ISCSIVolumeSource addPortalsItem(String portalsItem) {
        if (this.portals == null) {
            this.portals = new ArrayList<String>();
        }
        this.portals.add(portalsItem);
        return this;
    }

    @ApiModelProperty(value="iSCSI target portal List. The portal is either an IP or ip_addr:port if the port is other than default (typically TCP ports 860 and 3260).")
    public List<String> getPortals() {
        return this.portals;
    }

    public void setPortals(List<String> portals) {
        this.portals = portals;
    }

    public V1ISCSIVolumeSource readOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    @ApiModelProperty(value="ReadOnly here will force the ReadOnly setting in VolumeMounts. Defaults to false.")
    public Boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    public V1ISCSIVolumeSource targetPortal(String targetPortal) {
        this.targetPortal = targetPortal;
        return this;
    }

    @ApiModelProperty(required=true, value="iSCSI target portal. The portal is either an IP or ip_addr:port if the port is other than default (typically TCP ports 860 and 3260).")
    public String getTargetPortal() {
        return this.targetPortal;
    }

    public void setTargetPortal(String targetPortal) {
        this.targetPortal = targetPortal;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1ISCSIVolumeSource v1ISCSIVolumeSource = (V1ISCSIVolumeSource)o;
        return Objects.equals(this.fsType, v1ISCSIVolumeSource.fsType) && Objects.equals(this.iqn, v1ISCSIVolumeSource.iqn) && Objects.equals(this.iscsiInterface, v1ISCSIVolumeSource.iscsiInterface) && Objects.equals(this.lun, v1ISCSIVolumeSource.lun) && Objects.equals(this.portals, v1ISCSIVolumeSource.portals) && Objects.equals(this.readOnly, v1ISCSIVolumeSource.readOnly) && Objects.equals(this.targetPortal, v1ISCSIVolumeSource.targetPortal);
    }

    public int hashCode() {
        return Objects.hash(this.fsType, this.iqn, this.iscsiInterface, this.lun, this.portals, this.readOnly, this.targetPortal);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1ISCSIVolumeSource {\n");
        sb.append("    fsType: ").append(this.toIndentedString(this.fsType)).append("\n");
        sb.append("    iqn: ").append(this.toIndentedString(this.iqn)).append("\n");
        sb.append("    iscsiInterface: ").append(this.toIndentedString(this.iscsiInterface)).append("\n");
        sb.append("    lun: ").append(this.toIndentedString(this.lun)).append("\n");
        sb.append("    portals: ").append(this.toIndentedString(this.portals)).append("\n");
        sb.append("    readOnly: ").append(this.toIndentedString(this.readOnly)).append("\n");
        sb.append("    targetPortal: ").append(this.toIndentedString(this.targetPortal)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

