/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Represents a Persistent Disk resource in Google Compute Engine.  A GCE PD must exist before mounting to a container. The disk must also be in the same GCE project and zone as the kubelet. A GCE PD can only be mounted as read/write once or read-only many times. GCE PDs support ownership management and SELinux relabeling.")
public class V1GCEPersistentDiskVolumeSource {
    @SerializedName(value="fsType")
    private String fsType = null;
    @SerializedName(value="partition")
    private Integer partition = null;
    @SerializedName(value="pdName")
    private String pdName = null;
    @SerializedName(value="readOnly")
    private Boolean readOnly = null;

    public V1GCEPersistentDiskVolumeSource fsType(String fsType) {
        this.fsType = fsType;
        return this;
    }

    @ApiModelProperty(value="Filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: \"ext4\", \"xfs\", \"ntfs\". Implicitly inferred to be \"ext4\" if unspecified. More info: http://kubernetes.io/docs/user-guide/volumes#gcepersistentdisk")
    public String getFsType() {
        return this.fsType;
    }

    public void setFsType(String fsType) {
        this.fsType = fsType;
    }

    public V1GCEPersistentDiskVolumeSource partition(Integer partition) {
        this.partition = partition;
        return this;
    }

    @ApiModelProperty(value="The partition in the volume that you want to mount. If omitted, the default is to mount by volume name. Examples: For volume /dev/sda1, you specify the partition as \"1\". Similarly, the volume partition for /dev/sda is \"0\" (or you can leave the property empty). More info: http://kubernetes.io/docs/user-guide/volumes#gcepersistentdisk")
    public Integer getPartition() {
        return this.partition;
    }

    public void setPartition(Integer partition) {
        this.partition = partition;
    }

    public V1GCEPersistentDiskVolumeSource pdName(String pdName) {
        this.pdName = pdName;
        return this;
    }

    @ApiModelProperty(required=true, value="Unique name of the PD resource in GCE. Used to identify the disk in GCE. More info: http://kubernetes.io/docs/user-guide/volumes#gcepersistentdisk")
    public String getPdName() {
        return this.pdName;
    }

    public void setPdName(String pdName) {
        this.pdName = pdName;
    }

    public V1GCEPersistentDiskVolumeSource readOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    @ApiModelProperty(value="ReadOnly here will force the ReadOnly setting in VolumeMounts. Defaults to false. More info: http://kubernetes.io/docs/user-guide/volumes#gcepersistentdisk")
    public Boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1GCEPersistentDiskVolumeSource v1GCEPersistentDiskVolumeSource = (V1GCEPersistentDiskVolumeSource)o;
        return Objects.equals(this.fsType, v1GCEPersistentDiskVolumeSource.fsType) && Objects.equals(this.partition, v1GCEPersistentDiskVolumeSource.partition) && Objects.equals(this.pdName, v1GCEPersistentDiskVolumeSource.pdName) && Objects.equals(this.readOnly, v1GCEPersistentDiskVolumeSource.readOnly);
    }

    public int hashCode() {
        return Objects.hash(this.fsType, this.partition, this.pdName, this.readOnly);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1GCEPersistentDiskVolumeSource {\n");
        sb.append("    fsType: ").append(this.toIndentedString(this.fsType)).append("\n");
        sb.append("    partition: ").append(this.toIndentedString(this.partition)).append("\n");
        sb.append("    pdName: ").append(this.toIndentedString(this.pdName)).append("\n");
        sb.append("    readOnly: ").append(this.toIndentedString(this.readOnly)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

