/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.models.V1ContainerState;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="ContainerStatus contains details for the current status of this container.")
public class V1ContainerStatus {
    @SerializedName(value="containerID")
    private String containerID = null;
    @SerializedName(value="image")
    private String image = null;
    @SerializedName(value="imageID")
    private String imageID = null;
    @SerializedName(value="lastState")
    private V1ContainerState lastState = null;
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="ready")
    private Boolean ready = null;
    @SerializedName(value="restartCount")
    private Integer restartCount = null;
    @SerializedName(value="state")
    private V1ContainerState state = null;

    public V1ContainerStatus containerID(String containerID) {
        this.containerID = containerID;
        return this;
    }

    @ApiModelProperty(value="Container's ID in the format 'docker://<container_id>'. More info: http://kubernetes.io/docs/user-guide/container-environment#container-information")
    public String getContainerID() {
        return this.containerID;
    }

    public void setContainerID(String containerID) {
        this.containerID = containerID;
    }

    public V1ContainerStatus image(String image) {
        this.image = image;
        return this;
    }

    @ApiModelProperty(required=true, value="The image the container is running. More info: http://kubernetes.io/docs/user-guide/images")
    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public V1ContainerStatus imageID(String imageID) {
        this.imageID = imageID;
        return this;
    }

    @ApiModelProperty(required=true, value="ImageID of the container's image.")
    public String getImageID() {
        return this.imageID;
    }

    public void setImageID(String imageID) {
        this.imageID = imageID;
    }

    public V1ContainerStatus lastState(V1ContainerState lastState) {
        this.lastState = lastState;
        return this;
    }

    @ApiModelProperty(value="Details about the container's last termination condition.")
    public V1ContainerState getLastState() {
        return this.lastState;
    }

    public void setLastState(V1ContainerState lastState) {
        this.lastState = lastState;
    }

    public V1ContainerStatus name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="This must be a DNS_LABEL. Each container in a pod must have a unique name. Cannot be updated.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public V1ContainerStatus ready(Boolean ready) {
        this.ready = ready;
        return this;
    }

    @ApiModelProperty(required=true, value="Specifies whether the container has passed its readiness probe.")
    public Boolean isReady() {
        return this.ready;
    }

    public void setReady(Boolean ready) {
        this.ready = ready;
    }

    public V1ContainerStatus restartCount(Integer restartCount) {
        this.restartCount = restartCount;
        return this;
    }

    @ApiModelProperty(required=true, value="The number of times the container has been restarted, currently based on the number of dead containers that have not yet been removed. Note that this is calculated from dead containers. But those containers are subject to garbage collection. This value will get capped at 5 by GC.")
    public Integer getRestartCount() {
        return this.restartCount;
    }

    public void setRestartCount(Integer restartCount) {
        this.restartCount = restartCount;
    }

    public V1ContainerStatus state(V1ContainerState state) {
        this.state = state;
        return this;
    }

    @ApiModelProperty(value="Details about the container's current condition.")
    public V1ContainerState getState() {
        return this.state;
    }

    public void setState(V1ContainerState state) {
        this.state = state;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1ContainerStatus v1ContainerStatus = (V1ContainerStatus)o;
        return Objects.equals(this.containerID, v1ContainerStatus.containerID) && Objects.equals(this.image, v1ContainerStatus.image) && Objects.equals(this.imageID, v1ContainerStatus.imageID) && Objects.equals(this.lastState, v1ContainerStatus.lastState) && Objects.equals(this.name, v1ContainerStatus.name) && Objects.equals(this.ready, v1ContainerStatus.ready) && Objects.equals(this.restartCount, v1ContainerStatus.restartCount) && Objects.equals(this.state, v1ContainerStatus.state);
    }

    public int hashCode() {
        return Objects.hash(this.containerID, this.image, this.imageID, this.lastState, this.name, this.ready, this.restartCount, this.state);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1ContainerStatus {\n");
        sb.append("    containerID: ").append(this.toIndentedString(this.containerID)).append("\n");
        sb.append("    image: ").append(this.toIndentedString(this.image)).append("\n");
        sb.append("    imageID: ").append(this.toIndentedString(this.imageID)).append("\n");
        sb.append("    lastState: ").append(this.toIndentedString(this.lastState)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    ready: ").append(this.toIndentedString(this.ready)).append("\n");
        sb.append("    restartCount: ").append(this.toIndentedString(this.restartCount)).append("\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

