/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="APIResource specifies the name of a resource and whether it is namespaced.")
public class V1APIResource {
    @SerializedName(value="kind")
    private String kind = null;
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="namespaced")
    private Boolean namespaced = null;
    @SerializedName(value="shortNames")
    private List<String> shortNames = null;
    @SerializedName(value="verbs")
    private List<String> verbs = new ArrayList<String>();

    public V1APIResource kind(String kind) {
        this.kind = kind;
        return this;
    }

    @ApiModelProperty(required=true, value="kind is the kind for the resource (e.g. 'Foo' is the kind for a resource 'foo')")
    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public V1APIResource name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="name is the name of the resource.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public V1APIResource namespaced(Boolean namespaced) {
        this.namespaced = namespaced;
        return this;
    }

    @ApiModelProperty(required=true, value="namespaced indicates if a resource is namespaced or not.")
    public Boolean isNamespaced() {
        return this.namespaced;
    }

    public void setNamespaced(Boolean namespaced) {
        this.namespaced = namespaced;
    }

    public V1APIResource shortNames(List<String> shortNames) {
        this.shortNames = shortNames;
        return this;
    }

    public V1APIResource addShortNamesItem(String shortNamesItem) {
        if (this.shortNames == null) {
            this.shortNames = new ArrayList<String>();
        }
        this.shortNames.add(shortNamesItem);
        return this;
    }

    @ApiModelProperty(value="shortNames is a list of suggested short names of the resource.")
    public List<String> getShortNames() {
        return this.shortNames;
    }

    public void setShortNames(List<String> shortNames) {
        this.shortNames = shortNames;
    }

    public V1APIResource verbs(List<String> verbs) {
        this.verbs = verbs;
        return this;
    }

    public V1APIResource addVerbsItem(String verbsItem) {
        this.verbs.add(verbsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="verbs is a list of supported kube verbs (this includes get, list, watch, create, update, patch, delete, deletecollection, and proxy)")
    public List<String> getVerbs() {
        return this.verbs;
    }

    public void setVerbs(List<String> verbs) {
        this.verbs = verbs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1APIResource v1APIResource = (V1APIResource)o;
        return Objects.equals(this.kind, v1APIResource.kind) && Objects.equals(this.name, v1APIResource.name) && Objects.equals(this.namespaced, v1APIResource.namespaced) && Objects.equals(this.shortNames, v1APIResource.shortNames) && Objects.equals(this.verbs, v1APIResource.verbs);
    }

    public int hashCode() {
        return Objects.hash(this.kind, this.name, this.namespaced, this.shortNames, this.verbs);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1APIResource {\n");
        sb.append("    kind: ").append(this.toIndentedString(this.kind)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    namespaced: ").append(this.toIndentedString(this.namespaced)).append("\n");
        sb.append("    shortNames: ").append(this.toIndentedString(this.shortNames)).append("\n");
        sb.append("    verbs: ").append(this.toIndentedString(this.verbs)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

