/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="The ResourceClaim this DeviceToleration is attached to tolerates any taint that matches the triple <key,value,effect> using the matching operator <operator>.")
public class V1beta2DeviceToleration {
    public static final String SERIALIZED_NAME_EFFECT = "effect";
    @SerializedName(value="effect")
    @Nullable
    private String effect;
    public static final String SERIALIZED_NAME_KEY = "key";
    @SerializedName(value="key")
    @Nullable
    private String key;
    public static final String SERIALIZED_NAME_OPERATOR = "operator";
    @SerializedName(value="operator")
    @Nullable
    private String operator;
    public static final String SERIALIZED_NAME_TOLERATION_SECONDS = "tolerationSeconds";
    @SerializedName(value="tolerationSeconds")
    @Nullable
    private Long tolerationSeconds;
    public static final String SERIALIZED_NAME_VALUE = "value";
    @SerializedName(value="value")
    @Nullable
    private String value;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1beta2DeviceToleration effect(@Nullable String effect) {
        this.effect = effect;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Effect indicates the taint effect to match. Empty means match all taint effects. When specified, allowed values are NoSchedule and NoExecute.")
    public String getEffect() {
        return this.effect;
    }

    public void setEffect(@Nullable String effect) {
        this.effect = effect;
    }

    public V1beta2DeviceToleration key(@Nullable String key) {
        this.key = key;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Key is the taint key that the toleration applies to. Empty means match all taint keys. If the key is empty, operator must be Exists; this combination means to match all values and all keys. Must be a label name.")
    public String getKey() {
        return this.key;
    }

    public void setKey(@Nullable String key) {
        this.key = key;
    }

    public V1beta2DeviceToleration operator(@Nullable String operator) {
        this.operator = operator;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Operator represents a key's relationship to the value. Valid operators are Exists and Equal. Defaults to Equal. Exists is equivalent to wildcard for value, so that a ResourceClaim can tolerate all taints of a particular category.")
    public String getOperator() {
        return this.operator;
    }

    public void setOperator(@Nullable String operator) {
        this.operator = operator;
    }

    public V1beta2DeviceToleration tolerationSeconds(@Nullable Long tolerationSeconds) {
        this.tolerationSeconds = tolerationSeconds;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="TolerationSeconds represents the period of time the toleration (which must be of effect NoExecute, otherwise this field is ignored) tolerates the taint. By default, it is not set, which means tolerate the taint forever (do not evict). Zero and negative values will be treated as 0 (evict immediately) by the system. If larger than zero, the time when the pod needs to be evicted is calculated as <time when taint was adedd> + <toleration seconds>.")
    public Long getTolerationSeconds() {
        return this.tolerationSeconds;
    }

    public void setTolerationSeconds(@Nullable Long tolerationSeconds) {
        this.tolerationSeconds = tolerationSeconds;
    }

    public V1beta2DeviceToleration value(@Nullable String value) {
        this.value = value;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Value is the taint value the toleration matches to. If the operator is Exists, the value must be empty, otherwise just a regular string. Must be a label value.")
    public String getValue() {
        return this.value;
    }

    public void setValue(@Nullable String value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1beta2DeviceToleration v1beta2DeviceToleration = (V1beta2DeviceToleration)o;
        return Objects.equals(this.effect, v1beta2DeviceToleration.effect) && Objects.equals(this.key, v1beta2DeviceToleration.key) && Objects.equals(this.operator, v1beta2DeviceToleration.operator) && Objects.equals(this.tolerationSeconds, v1beta2DeviceToleration.tolerationSeconds) && Objects.equals(this.value, v1beta2DeviceToleration.value);
    }

    public int hashCode() {
        return Objects.hash(this.effect, this.key, this.operator, this.tolerationSeconds, this.value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1beta2DeviceToleration {\n");
        sb.append("    effect: ").append(this.toIndentedString(this.effect)).append("\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    operator: ").append(this.toIndentedString(this.operator)).append("\n");
        sb.append("    tolerationSeconds: ").append(this.toIndentedString(this.tolerationSeconds)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1beta2DeviceToleration is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1beta2DeviceToleration` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_EFFECT) != null && !jsonObj.get(SERIALIZED_NAME_EFFECT).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_EFFECT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `effect` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_EFFECT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_KEY) != null && !jsonObj.get(SERIALIZED_NAME_KEY).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_KEY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `key` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_KEY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_OPERATOR) != null && !jsonObj.get(SERIALIZED_NAME_OPERATOR).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_OPERATOR).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `operator` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_OPERATOR).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_VALUE) != null && !jsonObj.get(SERIALIZED_NAME_VALUE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_VALUE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `value` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VALUE).toString()));
        }
    }

    public static V1beta2DeviceToleration fromJson(String jsonString) throws IOException {
        return (V1beta2DeviceToleration)JSON.getGson().fromJson(jsonString, V1beta2DeviceToleration.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_EFFECT);
        openapiFields.add(SERIALIZED_NAME_KEY);
        openapiFields.add(SERIALIZED_NAME_OPERATOR);
        openapiFields.add(SERIALIZED_NAME_TOLERATION_SECONDS);
        openapiFields.add(SERIALIZED_NAME_VALUE);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1beta2DeviceToleration.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1beta2DeviceToleration.class));
            return new TypeAdapter<V1beta2DeviceToleration>(){

                public void write(JsonWriter out, V1beta2DeviceToleration value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1beta2DeviceToleration read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1beta2DeviceToleration.validateJsonElement(jsonElement);
                    return (V1beta2DeviceToleration)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

