/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V1beta2Counter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="DeviceCounterConsumption defines a set of counters that a device will consume from a CounterSet.")
public class V1beta2DeviceCounterConsumption {
    public static final String SERIALIZED_NAME_COUNTER_SET = "counterSet";
    @SerializedName(value="counterSet")
    @Nonnull
    private String counterSet;
    public static final String SERIALIZED_NAME_COUNTERS = "counters";
    @SerializedName(value="counters")
    @Nonnull
    private Map<String, V1beta2Counter> counters = new HashMap<String, V1beta2Counter>();
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1beta2DeviceCounterConsumption counterSet(@Nonnull String counterSet) {
        this.counterSet = counterSet;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="CounterSet is the name of the set from which the counters defined will be consumed.")
    public String getCounterSet() {
        return this.counterSet;
    }

    public void setCounterSet(@Nonnull String counterSet) {
        this.counterSet = counterSet;
    }

    public V1beta2DeviceCounterConsumption counters(@Nonnull Map<String, V1beta2Counter> counters) {
        this.counters = counters;
        return this;
    }

    public V1beta2DeviceCounterConsumption putCountersItem(String key, V1beta2Counter countersItem) {
        if (this.counters == null) {
            this.counters = new HashMap<String, V1beta2Counter>();
        }
        this.counters.put(key, countersItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Counters defines the counters that will be consumed by the device.  The maximum number counters in a device is 32. In addition, the maximum number of all counters in all devices is 1024 (for example, 64 devices with 16 counters each).")
    public Map<String, V1beta2Counter> getCounters() {
        return this.counters;
    }

    public void setCounters(@Nonnull Map<String, V1beta2Counter> counters) {
        this.counters = counters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1beta2DeviceCounterConsumption v1beta2DeviceCounterConsumption = (V1beta2DeviceCounterConsumption)o;
        return Objects.equals(this.counterSet, v1beta2DeviceCounterConsumption.counterSet) && Objects.equals(this.counters, v1beta2DeviceCounterConsumption.counters);
    }

    public int hashCode() {
        return Objects.hash(this.counterSet, this.counters);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1beta2DeviceCounterConsumption {\n");
        sb.append("    counterSet: ").append(this.toIndentedString(this.counterSet)).append("\n");
        sb.append("    counters: ").append(this.toIndentedString(this.counters)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1beta2DeviceCounterConsumption is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1beta2DeviceCounterConsumption` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.get(SERIALIZED_NAME_COUNTER_SET).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `counterSet` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_COUNTER_SET).toString()));
        }
    }

    public static V1beta2DeviceCounterConsumption fromJson(String jsonString) throws IOException {
        return (V1beta2DeviceCounterConsumption)JSON.getGson().fromJson(jsonString, V1beta2DeviceCounterConsumption.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_COUNTER_SET);
        openapiFields.add(SERIALIZED_NAME_COUNTERS);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_COUNTER_SET);
        openapiRequiredFields.add(SERIALIZED_NAME_COUNTERS);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1beta2DeviceCounterConsumption.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1beta2DeviceCounterConsumption.class));
            return new TypeAdapter<V1beta2DeviceCounterConsumption>(){

                public void write(JsonWriter out, V1beta2DeviceCounterConsumption value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1beta2DeviceCounterConsumption read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1beta2DeviceCounterConsumption.validateJsonElement(jsonElement);
                    return (V1beta2DeviceCounterConsumption)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

