/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V1LimitRangeItem;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="LimitRangeSpec defines a min/max usage limit for resources that match on kind.")
public class V1LimitRangeSpec {
    public static final String SERIALIZED_NAME_LIMITS = "limits";
    @SerializedName(value="limits")
    @Nonnull
    private List<V1LimitRangeItem> limits = new ArrayList<V1LimitRangeItem>();
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1LimitRangeSpec limits(@Nonnull List<V1LimitRangeItem> limits) {
        this.limits = limits;
        return this;
    }

    public V1LimitRangeSpec addLimitsItem(V1LimitRangeItem limitsItem) {
        if (this.limits == null) {
            this.limits = new ArrayList<V1LimitRangeItem>();
        }
        this.limits.add(limitsItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Limits is the list of LimitRangeItem objects that are enforced.")
    public List<V1LimitRangeItem> getLimits() {
        return this.limits;
    }

    public void setLimits(@Nonnull List<V1LimitRangeItem> limits) {
        this.limits = limits;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1LimitRangeSpec v1LimitRangeSpec = (V1LimitRangeSpec)o;
        return Objects.equals(this.limits, v1LimitRangeSpec.limits);
    }

    public int hashCode() {
        return Objects.hash(this.limits);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1LimitRangeSpec {\n");
        sb.append("    limits: ").append(this.toIndentedString(this.limits)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1LimitRangeSpec is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1LimitRangeSpec` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.get(SERIALIZED_NAME_LIMITS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `limits` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_LIMITS).toString()));
        }
        JsonArray jsonArraylimits = jsonObj.getAsJsonArray(SERIALIZED_NAME_LIMITS);
        for (int i = 0; i < jsonArraylimits.size(); ++i) {
            V1LimitRangeItem.validateJsonElement(jsonArraylimits.get(i));
        }
    }

    public static V1LimitRangeSpec fromJson(String jsonString) throws IOException {
        return (V1LimitRangeSpec)JSON.getGson().fromJson(jsonString, V1LimitRangeSpec.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_LIMITS);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_LIMITS);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1LimitRangeSpec.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1LimitRangeSpec.class));
            return new TypeAdapter<V1LimitRangeSpec>(){

                public void write(JsonWriter out, V1LimitRangeSpec value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1LimitRangeSpec read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1LimitRangeSpec.validateJsonElement(jsonElement);
                    return (V1LimitRangeSpec)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

