/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1JobCondition;
import io.kubernetes.client.openapi.models.V1JobConditionBuilder;
import io.kubernetes.client.openapi.models.V1JobConditionFluent;
import io.kubernetes.client.openapi.models.V1JobStatus;
import io.kubernetes.client.openapi.models.V1UncountedTerminatedPods;
import io.kubernetes.client.openapi.models.V1UncountedTerminatedPodsBuilder;
import io.kubernetes.client.openapi.models.V1UncountedTerminatedPodsFluent;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class V1JobStatusFluent<A extends V1JobStatusFluent<A>>
extends BaseFluent<A> {
    private Integer active;
    private String completedIndexes;
    private OffsetDateTime completionTime;
    private ArrayList<V1JobConditionBuilder> conditions;
    private Integer failed;
    private String failedIndexes;
    private Integer ready;
    private OffsetDateTime startTime;
    private Integer succeeded;
    private Integer terminating;
    private V1UncountedTerminatedPodsBuilder uncountedTerminatedPods;

    public V1JobStatusFluent() {
    }

    public V1JobStatusFluent(V1JobStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1JobStatus instance) {
        V1JobStatus v1JobStatus = instance = instance != null ? instance : new V1JobStatus();
        if (instance != null) {
            this.withActive(instance.getActive());
            this.withCompletedIndexes(instance.getCompletedIndexes());
            this.withCompletionTime(instance.getCompletionTime());
            this.withConditions(instance.getConditions());
            this.withFailed(instance.getFailed());
            this.withFailedIndexes(instance.getFailedIndexes());
            this.withReady(instance.getReady());
            this.withStartTime(instance.getStartTime());
            this.withSucceeded(instance.getSucceeded());
            this.withTerminating(instance.getTerminating());
            this.withUncountedTerminatedPods(instance.getUncountedTerminatedPods());
        }
    }

    public Integer getActive() {
        return this.active;
    }

    public A withActive(Integer active) {
        this.active = active;
        return (A)this;
    }

    public boolean hasActive() {
        return this.active != null;
    }

    public String getCompletedIndexes() {
        return this.completedIndexes;
    }

    public A withCompletedIndexes(String completedIndexes) {
        this.completedIndexes = completedIndexes;
        return (A)this;
    }

    public boolean hasCompletedIndexes() {
        return this.completedIndexes != null;
    }

    public OffsetDateTime getCompletionTime() {
        return this.completionTime;
    }

    public A withCompletionTime(OffsetDateTime completionTime) {
        this.completionTime = completionTime;
        return (A)this;
    }

    public boolean hasCompletionTime() {
        return this.completionTime != null;
    }

    public A addToConditions(int index, V1JobCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        V1JobConditionBuilder builder = new V1JobConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get("conditions").add(builder);
            this.conditions.add(index, builder);
        }
        return (A)this;
    }

    public A setToConditions(int index, V1JobCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        V1JobConditionBuilder builder = new V1JobConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get("conditions").add(builder);
            this.conditions.set(index, builder);
        }
        return (A)this;
    }

    public A addToConditions(V1JobCondition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (V1JobCondition item : items) {
            V1JobConditionBuilder builder = new V1JobConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    public A addAllToConditions(Collection<V1JobCondition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (V1JobCondition item : items) {
            V1JobConditionBuilder builder = new V1JobConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    public A removeFromConditions(V1JobCondition ... items) {
        if (this.conditions == null) {
            return (A)this;
        }
        for (V1JobCondition item : items) {
            V1JobConditionBuilder builder = new V1JobConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromConditions(Collection<V1JobCondition> items) {
        if (this.conditions == null) {
            return (A)this;
        }
        for (V1JobCondition item : items) {
            V1JobConditionBuilder builder = new V1JobConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromConditions(Predicate<V1JobConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)this;
        }
        Iterator<V1JobConditionBuilder> each = this.conditions.iterator();
        Object visitables = this._visitables.get("conditions");
        while (each.hasNext()) {
            V1JobConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<V1JobCondition> buildConditions() {
        return this.conditions != null ? V1JobStatusFluent.build(this.conditions) : null;
    }

    public V1JobCondition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    public V1JobCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    public V1JobCondition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    public V1JobCondition buildMatchingCondition(Predicate<V1JobConditionBuilder> predicate) {
        for (V1JobConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingCondition(Predicate<V1JobConditionBuilder> predicate) {
        for (V1JobConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withConditions(List<V1JobCondition> conditions) {
        if (this.conditions != null) {
            this._visitables.get("conditions").clear();
        }
        if (conditions != null) {
            this.conditions = new ArrayList();
            for (V1JobCondition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    public A withConditions(V1JobCondition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove("conditions");
        }
        if (conditions != null) {
            for (V1JobCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public ConditionsNested<A> addNewCondition() {
        return new ConditionsNested(-1, null);
    }

    public ConditionsNested<A> addNewConditionLike(V1JobCondition item) {
        return new ConditionsNested(-1, item);
    }

    public ConditionsNested<A> setNewConditionLike(int index, V1JobCondition item) {
        return new ConditionsNested(index, item);
    }

    public ConditionsNested<A> editCondition(int index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    public ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editMatchingCondition(Predicate<V1JobConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public Integer getFailed() {
        return this.failed;
    }

    public A withFailed(Integer failed) {
        this.failed = failed;
        return (A)this;
    }

    public boolean hasFailed() {
        return this.failed != null;
    }

    public String getFailedIndexes() {
        return this.failedIndexes;
    }

    public A withFailedIndexes(String failedIndexes) {
        this.failedIndexes = failedIndexes;
        return (A)this;
    }

    public boolean hasFailedIndexes() {
        return this.failedIndexes != null;
    }

    public Integer getReady() {
        return this.ready;
    }

    public A withReady(Integer ready) {
        this.ready = ready;
        return (A)this;
    }

    public boolean hasReady() {
        return this.ready != null;
    }

    public OffsetDateTime getStartTime() {
        return this.startTime;
    }

    public A withStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return (A)this;
    }

    public boolean hasStartTime() {
        return this.startTime != null;
    }

    public Integer getSucceeded() {
        return this.succeeded;
    }

    public A withSucceeded(Integer succeeded) {
        this.succeeded = succeeded;
        return (A)this;
    }

    public boolean hasSucceeded() {
        return this.succeeded != null;
    }

    public Integer getTerminating() {
        return this.terminating;
    }

    public A withTerminating(Integer terminating) {
        this.terminating = terminating;
        return (A)this;
    }

    public boolean hasTerminating() {
        return this.terminating != null;
    }

    public V1UncountedTerminatedPods buildUncountedTerminatedPods() {
        return this.uncountedTerminatedPods != null ? this.uncountedTerminatedPods.build() : null;
    }

    public A withUncountedTerminatedPods(V1UncountedTerminatedPods uncountedTerminatedPods) {
        this._visitables.remove("uncountedTerminatedPods");
        if (uncountedTerminatedPods != null) {
            this.uncountedTerminatedPods = new V1UncountedTerminatedPodsBuilder(uncountedTerminatedPods);
            this._visitables.get("uncountedTerminatedPods").add(this.uncountedTerminatedPods);
        } else {
            this.uncountedTerminatedPods = null;
            this._visitables.get("uncountedTerminatedPods").remove(this.uncountedTerminatedPods);
        }
        return (A)this;
    }

    public boolean hasUncountedTerminatedPods() {
        return this.uncountedTerminatedPods != null;
    }

    public UncountedTerminatedPodsNested<A> withNewUncountedTerminatedPods() {
        return new UncountedTerminatedPodsNested(null);
    }

    public UncountedTerminatedPodsNested<A> withNewUncountedTerminatedPodsLike(V1UncountedTerminatedPods item) {
        return new UncountedTerminatedPodsNested(item);
    }

    public UncountedTerminatedPodsNested<A> editUncountedTerminatedPods() {
        return this.withNewUncountedTerminatedPodsLike(Optional.ofNullable(this.buildUncountedTerminatedPods()).orElse(null));
    }

    public UncountedTerminatedPodsNested<A> editOrNewUncountedTerminatedPods() {
        return this.withNewUncountedTerminatedPodsLike(Optional.ofNullable(this.buildUncountedTerminatedPods()).orElse(new V1UncountedTerminatedPodsBuilder().build()));
    }

    public UncountedTerminatedPodsNested<A> editOrNewUncountedTerminatedPodsLike(V1UncountedTerminatedPods item) {
        return this.withNewUncountedTerminatedPodsLike(Optional.ofNullable(this.buildUncountedTerminatedPods()).orElse(item));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1JobStatusFluent that = (V1JobStatusFluent)o;
        if (!Objects.equals(this.active, that.active)) {
            return false;
        }
        if (!Objects.equals(this.completedIndexes, that.completedIndexes)) {
            return false;
        }
        if (!Objects.equals(this.completionTime, that.completionTime)) {
            return false;
        }
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals(this.failed, that.failed)) {
            return false;
        }
        if (!Objects.equals(this.failedIndexes, that.failedIndexes)) {
            return false;
        }
        if (!Objects.equals(this.ready, that.ready)) {
            return false;
        }
        if (!Objects.equals(this.startTime, that.startTime)) {
            return false;
        }
        if (!Objects.equals(this.succeeded, that.succeeded)) {
            return false;
        }
        if (!Objects.equals(this.terminating, that.terminating)) {
            return false;
        }
        return Objects.equals(this.uncountedTerminatedPods, that.uncountedTerminatedPods);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.active, this.completedIndexes, this.completionTime, this.conditions, this.failed, this.failedIndexes, this.ready, this.startTime, this.succeeded, this.terminating, this.uncountedTerminatedPods, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.active != null) {
            sb.append("active:");
            sb.append(this.active + ",");
        }
        if (this.completedIndexes != null) {
            sb.append("completedIndexes:");
            sb.append(this.completedIndexes + ",");
        }
        if (this.completionTime != null) {
            sb.append("completionTime:");
            sb.append(String.valueOf(this.completionTime) + ",");
        }
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(String.valueOf(this.conditions) + ",");
        }
        if (this.failed != null) {
            sb.append("failed:");
            sb.append(this.failed + ",");
        }
        if (this.failedIndexes != null) {
            sb.append("failedIndexes:");
            sb.append(this.failedIndexes + ",");
        }
        if (this.ready != null) {
            sb.append("ready:");
            sb.append(this.ready + ",");
        }
        if (this.startTime != null) {
            sb.append("startTime:");
            sb.append(String.valueOf(this.startTime) + ",");
        }
        if (this.succeeded != null) {
            sb.append("succeeded:");
            sb.append(this.succeeded + ",");
        }
        if (this.terminating != null) {
            sb.append("terminating:");
            sb.append(this.terminating + ",");
        }
        if (this.uncountedTerminatedPods != null) {
            sb.append("uncountedTerminatedPods:");
            sb.append(this.uncountedTerminatedPods);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ConditionsNested<N>
    extends V1JobConditionFluent<ConditionsNested<N>>
    implements Nested<N> {
        V1JobConditionBuilder builder;
        int index;

        ConditionsNested(int index, V1JobCondition item) {
            this.index = index;
            this.builder = new V1JobConditionBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1JobStatusFluent.this.setToConditions(this.index, this.builder.build());
        }

        public N endCondition() {
            return this.and();
        }
    }

    public class UncountedTerminatedPodsNested<N>
    extends V1UncountedTerminatedPodsFluent<UncountedTerminatedPodsNested<N>>
    implements Nested<N> {
        V1UncountedTerminatedPodsBuilder builder;

        UncountedTerminatedPodsNested(V1UncountedTerminatedPods item) {
            this.builder = new V1UncountedTerminatedPodsBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1JobStatusFluent.this.withUncountedTerminatedPods(this.builder.build());
        }

        public N endUncountedTerminatedPods() {
            return this.and();
        }
    }
}

