/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1APIResource;
import io.kubernetes.client.openapi.models.V1APIResourceBuilder;
import io.kubernetes.client.openapi.models.V1APIResourceFluent;
import io.kubernetes.client.openapi.models.V1APIResourceList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class V1APIResourceListFluent<A extends V1APIResourceListFluent<A>>
extends BaseFluent<A> {
    private String apiVersion;
    private String groupVersion;
    private String kind;
    private ArrayList<V1APIResourceBuilder> resources;

    public V1APIResourceListFluent() {
    }

    public V1APIResourceListFluent(V1APIResourceList instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1APIResourceList instance) {
        V1APIResourceList v1APIResourceList = instance = instance != null ? instance : new V1APIResourceList();
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withGroupVersion(instance.getGroupVersion());
            this.withKind(instance.getKind());
            this.withResources(instance.getResources());
        }
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    public boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public String getGroupVersion() {
        return this.groupVersion;
    }

    public A withGroupVersion(String groupVersion) {
        this.groupVersion = groupVersion;
        return (A)this;
    }

    public boolean hasGroupVersion() {
        return this.groupVersion != null;
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public A addToResources(int index, V1APIResource item) {
        if (this.resources == null) {
            this.resources = new ArrayList();
        }
        V1APIResourceBuilder builder = new V1APIResourceBuilder(item);
        if (index < 0 || index >= this.resources.size()) {
            this._visitables.get("resources").add(builder);
            this.resources.add(builder);
        } else {
            this._visitables.get("resources").add(builder);
            this.resources.add(index, builder);
        }
        return (A)this;
    }

    public A setToResources(int index, V1APIResource item) {
        if (this.resources == null) {
            this.resources = new ArrayList();
        }
        V1APIResourceBuilder builder = new V1APIResourceBuilder(item);
        if (index < 0 || index >= this.resources.size()) {
            this._visitables.get("resources").add(builder);
            this.resources.add(builder);
        } else {
            this._visitables.get("resources").add(builder);
            this.resources.set(index, builder);
        }
        return (A)this;
    }

    public A addToResources(V1APIResource ... items) {
        if (this.resources == null) {
            this.resources = new ArrayList();
        }
        for (V1APIResource item : items) {
            V1APIResourceBuilder builder = new V1APIResourceBuilder(item);
            this._visitables.get("resources").add(builder);
            this.resources.add(builder);
        }
        return (A)this;
    }

    public A addAllToResources(Collection<V1APIResource> items) {
        if (this.resources == null) {
            this.resources = new ArrayList();
        }
        for (V1APIResource item : items) {
            V1APIResourceBuilder builder = new V1APIResourceBuilder(item);
            this._visitables.get("resources").add(builder);
            this.resources.add(builder);
        }
        return (A)this;
    }

    public A removeFromResources(V1APIResource ... items) {
        if (this.resources == null) {
            return (A)this;
        }
        for (V1APIResource item : items) {
            V1APIResourceBuilder builder = new V1APIResourceBuilder(item);
            this._visitables.get("resources").remove(builder);
            this.resources.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromResources(Collection<V1APIResource> items) {
        if (this.resources == null) {
            return (A)this;
        }
        for (V1APIResource item : items) {
            V1APIResourceBuilder builder = new V1APIResourceBuilder(item);
            this._visitables.get("resources").remove(builder);
            this.resources.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromResources(Predicate<V1APIResourceBuilder> predicate) {
        if (this.resources == null) {
            return (A)this;
        }
        Iterator<V1APIResourceBuilder> each = this.resources.iterator();
        Object visitables = this._visitables.get("resources");
        while (each.hasNext()) {
            V1APIResourceBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<V1APIResource> buildResources() {
        return this.resources != null ? V1APIResourceListFluent.build(this.resources) : null;
    }

    public V1APIResource buildResource(int index) {
        return this.resources.get(index).build();
    }

    public V1APIResource buildFirstResource() {
        return this.resources.get(0).build();
    }

    public V1APIResource buildLastResource() {
        return this.resources.get(this.resources.size() - 1).build();
    }

    public V1APIResource buildMatchingResource(Predicate<V1APIResourceBuilder> predicate) {
        for (V1APIResourceBuilder item : this.resources) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingResource(Predicate<V1APIResourceBuilder> predicate) {
        for (V1APIResourceBuilder item : this.resources) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withResources(List<V1APIResource> resources) {
        if (this.resources != null) {
            this._visitables.get("resources").clear();
        }
        if (resources != null) {
            this.resources = new ArrayList();
            for (V1APIResource item : resources) {
                this.addToResources(item);
            }
        } else {
            this.resources = null;
        }
        return (A)this;
    }

    public A withResources(V1APIResource ... resources) {
        if (this.resources != null) {
            this.resources.clear();
            this._visitables.remove("resources");
        }
        if (resources != null) {
            for (V1APIResource item : resources) {
                this.addToResources(item);
            }
        }
        return (A)this;
    }

    public boolean hasResources() {
        return this.resources != null && !this.resources.isEmpty();
    }

    public ResourcesNested<A> addNewResource() {
        return new ResourcesNested(-1, null);
    }

    public ResourcesNested<A> addNewResourceLike(V1APIResource item) {
        return new ResourcesNested(-1, item);
    }

    public ResourcesNested<A> setNewResourceLike(int index, V1APIResource item) {
        return new ResourcesNested(index, item);
    }

    public ResourcesNested<A> editResource(int index) {
        if (this.resources.size() <= index) {
            throw new RuntimeException("Can't edit resources. Index exceeds size.");
        }
        return this.setNewResourceLike(index, this.buildResource(index));
    }

    public ResourcesNested<A> editFirstResource() {
        if (this.resources.size() == 0) {
            throw new RuntimeException("Can't edit first resources. The list is empty.");
        }
        return this.setNewResourceLike(0, this.buildResource(0));
    }

    public ResourcesNested<A> editLastResource() {
        int index = this.resources.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last resources. The list is empty.");
        }
        return this.setNewResourceLike(index, this.buildResource(index));
    }

    public ResourcesNested<A> editMatchingResource(Predicate<V1APIResourceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.resources.size(); ++i) {
            if (!predicate.test(this.resources.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching resources. No match found.");
        }
        return this.setNewResourceLike(index, this.buildResource(index));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1APIResourceListFluent that = (V1APIResourceListFluent)o;
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.groupVersion, that.groupVersion)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        return Objects.equals(this.resources, that.resources);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.apiVersion, this.groupVersion, this.kind, this.resources, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.groupVersion != null) {
            sb.append("groupVersion:");
            sb.append(this.groupVersion + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.resources != null && !this.resources.isEmpty()) {
            sb.append("resources:");
            sb.append(this.resources);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ResourcesNested<N>
    extends V1APIResourceFluent<ResourcesNested<N>>
    implements Nested<N> {
        V1APIResourceBuilder builder;
        int index;

        ResourcesNested(int index, V1APIResource item) {
            this.index = index;
            this.builder = new V1APIResourceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1APIResourceListFluent.this.setToResources(this.index, this.builder.build());
        }

        public N endResource() {
            return this.and();
        }
    }
}

