/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="ServiceReference holds a reference to Service.legacy.k8s.io")
public class AdmissionregistrationV1ServiceReference {
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    @Nonnull
    private String name;
    public static final String SERIALIZED_NAME_NAMESPACE = "namespace";
    @SerializedName(value="namespace")
    @Nonnull
    private String namespace;
    public static final String SERIALIZED_NAME_PATH = "path";
    @SerializedName(value="path")
    @Nullable
    private String path;
    public static final String SERIALIZED_NAME_PORT = "port";
    @SerializedName(value="port")
    @Nullable
    private Integer port;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public AdmissionregistrationV1ServiceReference name(@Nonnull String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="`name` is the name of the service. Required")
    public String getName() {
        return this.name;
    }

    public void setName(@Nonnull String name) {
        this.name = name;
    }

    public AdmissionregistrationV1ServiceReference namespace(@Nonnull String namespace) {
        this.namespace = namespace;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="`namespace` is the namespace of the service. Required")
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(@Nonnull String namespace) {
        this.namespace = namespace;
    }

    public AdmissionregistrationV1ServiceReference path(@Nullable String path) {
        this.path = path;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="`path` is an optional URL path which will be sent in any request to this service.")
    public String getPath() {
        return this.path;
    }

    public void setPath(@Nullable String path) {
        this.path = path;
    }

    public AdmissionregistrationV1ServiceReference port(@Nullable Integer port) {
        this.port = port;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If specified, the port on the service that hosting webhook. Default to 443 for backward compatibility. `port` should be a valid port number (1-65535, inclusive).")
    public Integer getPort() {
        return this.port;
    }

    public void setPort(@Nullable Integer port) {
        this.port = port;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AdmissionregistrationV1ServiceReference admissionregistrationV1ServiceReference = (AdmissionregistrationV1ServiceReference)o;
        return Objects.equals(this.name, admissionregistrationV1ServiceReference.name) && Objects.equals(this.namespace, admissionregistrationV1ServiceReference.namespace) && Objects.equals(this.path, admissionregistrationV1ServiceReference.path) && Objects.equals(this.port, admissionregistrationV1ServiceReference.port);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.namespace, this.path, this.port);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AdmissionregistrationV1ServiceReference {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    namespace: ").append(this.toIndentedString(this.namespace)).append("\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("    port: ").append(this.toIndentedString(this.port)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in AdmissionregistrationV1ServiceReference is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `AdmissionregistrationV1ServiceReference` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_NAMESPACE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `namespace` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAMESPACE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PATH) != null && !jsonObj.get(SERIALIZED_NAME_PATH).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_PATH).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `path` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PATH).toString()));
        }
    }

    public static AdmissionregistrationV1ServiceReference fromJson(String jsonString) throws IOException {
        return (AdmissionregistrationV1ServiceReference)JSON.getGson().fromJson(jsonString, AdmissionregistrationV1ServiceReference.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_NAMESPACE);
        openapiFields.add(SERIALIZED_NAME_PATH);
        openapiFields.add(SERIALIZED_NAME_PORT);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_NAME);
        openapiRequiredFields.add(SERIALIZED_NAME_NAMESPACE);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!AdmissionregistrationV1ServiceReference.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(AdmissionregistrationV1ServiceReference.class));
            return new TypeAdapter<AdmissionregistrationV1ServiceReference>(){

                public void write(JsonWriter out, AdmissionregistrationV1ServiceReference value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public AdmissionregistrationV1ServiceReference read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    AdmissionregistrationV1ServiceReference.validateJsonElement(jsonElement);
                    return (AdmissionregistrationV1ServiceReference)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

