/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V2ExternalMetricSource;
import io.kubernetes.client.openapi.models.V2MetricIdentifier;
import io.kubernetes.client.openapi.models.V2MetricIdentifierBuilder;
import io.kubernetes.client.openapi.models.V2MetricIdentifierFluent;
import io.kubernetes.client.openapi.models.V2MetricTarget;
import io.kubernetes.client.openapi.models.V2MetricTargetBuilder;
import io.kubernetes.client.openapi.models.V2MetricTargetFluent;
import java.util.Objects;
import java.util.Optional;

public class V2ExternalMetricSourceFluent<A extends V2ExternalMetricSourceFluent<A>>
extends BaseFluent<A> {
    private V2MetricIdentifierBuilder metric;
    private V2MetricTargetBuilder target;

    public V2ExternalMetricSourceFluent() {
    }

    public V2ExternalMetricSourceFluent(V2ExternalMetricSource instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V2ExternalMetricSource instance) {
        V2ExternalMetricSource v2ExternalMetricSource = instance = instance != null ? instance : new V2ExternalMetricSource();
        if (instance != null) {
            this.withMetric(instance.getMetric());
            this.withTarget(instance.getTarget());
        }
    }

    public V2MetricIdentifier buildMetric() {
        return this.metric != null ? this.metric.build() : null;
    }

    public A withMetric(V2MetricIdentifier metric) {
        this._visitables.remove("metric");
        if (metric != null) {
            this.metric = new V2MetricIdentifierBuilder(metric);
            this._visitables.get("metric").add(this.metric);
        } else {
            this.metric = null;
            this._visitables.get("metric").remove(this.metric);
        }
        return (A)this;
    }

    public boolean hasMetric() {
        return this.metric != null;
    }

    public MetricNested<A> withNewMetric() {
        return new MetricNested(null);
    }

    public MetricNested<A> withNewMetricLike(V2MetricIdentifier item) {
        return new MetricNested(item);
    }

    public MetricNested<A> editMetric() {
        return this.withNewMetricLike(Optional.ofNullable(this.buildMetric()).orElse(null));
    }

    public MetricNested<A> editOrNewMetric() {
        return this.withNewMetricLike(Optional.ofNullable(this.buildMetric()).orElse(new V2MetricIdentifierBuilder().build()));
    }

    public MetricNested<A> editOrNewMetricLike(V2MetricIdentifier item) {
        return this.withNewMetricLike(Optional.ofNullable(this.buildMetric()).orElse(item));
    }

    public V2MetricTarget buildTarget() {
        return this.target != null ? this.target.build() : null;
    }

    public A withTarget(V2MetricTarget target) {
        this._visitables.remove("target");
        if (target != null) {
            this.target = new V2MetricTargetBuilder(target);
            this._visitables.get("target").add(this.target);
        } else {
            this.target = null;
            this._visitables.get("target").remove(this.target);
        }
        return (A)this;
    }

    public boolean hasTarget() {
        return this.target != null;
    }

    public TargetNested<A> withNewTarget() {
        return new TargetNested(null);
    }

    public TargetNested<A> withNewTargetLike(V2MetricTarget item) {
        return new TargetNested(item);
    }

    public TargetNested<A> editTarget() {
        return this.withNewTargetLike(Optional.ofNullable(this.buildTarget()).orElse(null));
    }

    public TargetNested<A> editOrNewTarget() {
        return this.withNewTargetLike(Optional.ofNullable(this.buildTarget()).orElse(new V2MetricTargetBuilder().build()));
    }

    public TargetNested<A> editOrNewTargetLike(V2MetricTarget item) {
        return this.withNewTargetLike(Optional.ofNullable(this.buildTarget()).orElse(item));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V2ExternalMetricSourceFluent that = (V2ExternalMetricSourceFluent)o;
        if (!Objects.equals(this.metric, that.metric)) {
            return false;
        }
        return Objects.equals(this.target, that.target);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.metric, this.target, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.metric != null) {
            sb.append("metric:");
            sb.append(this.metric + ",");
        }
        if (this.target != null) {
            sb.append("target:");
            sb.append(this.target);
        }
        sb.append("}");
        return sb.toString();
    }

    public class MetricNested<N>
    extends V2MetricIdentifierFluent<MetricNested<N>>
    implements Nested<N> {
        V2MetricIdentifierBuilder builder;

        MetricNested(V2MetricIdentifier item) {
            this.builder = new V2MetricIdentifierBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V2ExternalMetricSourceFluent.this.withMetric(this.builder.build());
        }

        public N endMetric() {
            return this.and();
        }
    }

    public class TargetNested<N>
    extends V2MetricTargetFluent<TargetNested<N>>
    implements Nested<N> {
        V2MetricTargetBuilder builder;

        TargetNested(V2MetricTarget item) {
            this.builder = new V2MetricTargetBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V2ExternalMetricSourceFluent.this.withTarget(this.builder.build());
        }

        public N endTarget() {
            return this.and();
        }
    }
}

