/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V1alpha2AllocationResult;
import io.kubernetes.client.openapi.models.V1alpha2ResourceClaimConsumerReference;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class V1alpha2ResourceClaimStatus {
    public static final String SERIALIZED_NAME_ALLOCATION = "allocation";
    @SerializedName(value="allocation")
    private V1alpha2AllocationResult allocation;
    public static final String SERIALIZED_NAME_DEALLOCATION_REQUESTED = "deallocationRequested";
    @SerializedName(value="deallocationRequested")
    private Boolean deallocationRequested;
    public static final String SERIALIZED_NAME_DRIVER_NAME = "driverName";
    @SerializedName(value="driverName")
    private String driverName;
    public static final String SERIALIZED_NAME_RESERVED_FOR = "reservedFor";
    @SerializedName(value="reservedFor")
    private List<V1alpha2ResourceClaimConsumerReference> reservedFor;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1alpha2ResourceClaimStatus allocation(V1alpha2AllocationResult allocation) {
        this.allocation = allocation;
        return this;
    }

    @Nullable
    public V1alpha2AllocationResult getAllocation() {
        return this.allocation;
    }

    public void setAllocation(V1alpha2AllocationResult allocation) {
        this.allocation = allocation;
    }

    public V1alpha2ResourceClaimStatus deallocationRequested(Boolean deallocationRequested) {
        this.deallocationRequested = deallocationRequested;
        return this;
    }

    @Nullable
    public Boolean getDeallocationRequested() {
        return this.deallocationRequested;
    }

    public void setDeallocationRequested(Boolean deallocationRequested) {
        this.deallocationRequested = deallocationRequested;
    }

    public V1alpha2ResourceClaimStatus driverName(String driverName) {
        this.driverName = driverName;
        return this;
    }

    @Nullable
    public String getDriverName() {
        return this.driverName;
    }

    public void setDriverName(String driverName) {
        this.driverName = driverName;
    }

    public V1alpha2ResourceClaimStatus reservedFor(List<V1alpha2ResourceClaimConsumerReference> reservedFor) {
        this.reservedFor = reservedFor;
        return this;
    }

    public V1alpha2ResourceClaimStatus addReservedForItem(V1alpha2ResourceClaimConsumerReference reservedForItem) {
        if (this.reservedFor == null) {
            this.reservedFor = new ArrayList<V1alpha2ResourceClaimConsumerReference>();
        }
        this.reservedFor.add(reservedForItem);
        return this;
    }

    @Nullable
    public List<V1alpha2ResourceClaimConsumerReference> getReservedFor() {
        return this.reservedFor;
    }

    public void setReservedFor(List<V1alpha2ResourceClaimConsumerReference> reservedFor) {
        this.reservedFor = reservedFor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1alpha2ResourceClaimStatus v1alpha2ResourceClaimStatus = (V1alpha2ResourceClaimStatus)o;
        return Objects.equals(this.allocation, v1alpha2ResourceClaimStatus.allocation) && Objects.equals(this.deallocationRequested, v1alpha2ResourceClaimStatus.deallocationRequested) && Objects.equals(this.driverName, v1alpha2ResourceClaimStatus.driverName) && Objects.equals(this.reservedFor, v1alpha2ResourceClaimStatus.reservedFor);
    }

    public int hashCode() {
        return Objects.hash(this.allocation, this.deallocationRequested, this.driverName, this.reservedFor);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1alpha2ResourceClaimStatus {\n");
        sb.append("    allocation: ").append(this.toIndentedString(this.allocation)).append("\n");
        sb.append("    deallocationRequested: ").append(this.toIndentedString(this.deallocationRequested)).append("\n");
        sb.append("    driverName: ").append(this.toIndentedString(this.driverName)).append("\n");
        sb.append("    reservedFor: ").append(this.toIndentedString(this.reservedFor)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        JsonArray jsonArrayreservedFor;
        if (jsonObj == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1alpha2ResourceClaimStatus is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1alpha2ResourceClaimStatus` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ALLOCATION) != null && !jsonObj.get(SERIALIZED_NAME_ALLOCATION).isJsonNull()) {
            V1alpha2AllocationResult.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_ALLOCATION));
        }
        if (jsonObj.get(SERIALIZED_NAME_DRIVER_NAME) != null && !jsonObj.get(SERIALIZED_NAME_DRIVER_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_DRIVER_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `driverName` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DRIVER_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_RESERVED_FOR) != null && !jsonObj.get(SERIALIZED_NAME_RESERVED_FOR).isJsonNull() && (jsonArrayreservedFor = jsonObj.getAsJsonArray(SERIALIZED_NAME_RESERVED_FOR)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_RESERVED_FOR).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `reservedFor` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RESERVED_FOR).toString()));
            }
            for (int i = 0; i < jsonArrayreservedFor.size(); ++i) {
                V1alpha2ResourceClaimConsumerReference.validateJsonObject(jsonArrayreservedFor.get(i).getAsJsonObject());
            }
        }
    }

    public static V1alpha2ResourceClaimStatus fromJson(String jsonString) throws IOException {
        return (V1alpha2ResourceClaimStatus)JSON.getGson().fromJson(jsonString, V1alpha2ResourceClaimStatus.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ALLOCATION);
        openapiFields.add(SERIALIZED_NAME_DEALLOCATION_REQUESTED);
        openapiFields.add(SERIALIZED_NAME_DRIVER_NAME);
        openapiFields.add(SERIALIZED_NAME_RESERVED_FOR);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1alpha2ResourceClaimStatus.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1alpha2ResourceClaimStatus.class));
            return new TypeAdapter<V1alpha2ResourceClaimStatus>(){

                public void write(JsonWriter out, V1alpha2ResourceClaimStatus value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1alpha2ResourceClaimStatus read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    V1alpha2ResourceClaimStatus.validateJsonObject(jsonObj);
                    return (V1alpha2ResourceClaimStatus)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

