/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1KeyToPath;
import io.kubernetes.client.openapi.models.V1KeyToPathBuilder;
import io.kubernetes.client.openapi.models.V1KeyToPathFluent;
import io.kubernetes.client.openapi.models.V1SecretVolumeSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class V1SecretVolumeSourceFluent<A extends V1SecretVolumeSourceFluent<A>>
extends BaseFluent<A> {
    private Integer defaultMode;
    private ArrayList<V1KeyToPathBuilder> items;
    private Boolean optional;
    private String secretName;

    public V1SecretVolumeSourceFluent() {
    }

    public V1SecretVolumeSourceFluent(V1SecretVolumeSource instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1SecretVolumeSource instance) {
        V1SecretVolumeSource v1SecretVolumeSource = instance = instance != null ? instance : new V1SecretVolumeSource();
        if (instance != null) {
            this.withDefaultMode(instance.getDefaultMode());
            this.withItems(instance.getItems());
            this.withOptional(instance.getOptional());
            this.withSecretName(instance.getSecretName());
        }
    }

    public Integer getDefaultMode() {
        return this.defaultMode;
    }

    public A withDefaultMode(Integer defaultMode) {
        this.defaultMode = defaultMode;
        return (A)this;
    }

    public boolean hasDefaultMode() {
        return this.defaultMode != null;
    }

    public A addToItems(int index, V1KeyToPath item) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        V1KeyToPathBuilder builder = new V1KeyToPathBuilder(item);
        if (index < 0 || index >= this.items.size()) {
            this._visitables.get("items").add(builder);
            this.items.add(builder);
        } else {
            this._visitables.get("items").add(index, builder);
            this.items.add(index, builder);
        }
        return (A)this;
    }

    public A setToItems(int index, V1KeyToPath item) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        V1KeyToPathBuilder builder = new V1KeyToPathBuilder(item);
        if (index < 0 || index >= this.items.size()) {
            this._visitables.get("items").add(builder);
            this.items.add(builder);
        } else {
            this._visitables.get("items").set(index, builder);
            this.items.set(index, builder);
        }
        return (A)this;
    }

    public A addToItems(V1KeyToPath ... items) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        for (V1KeyToPath item : items) {
            V1KeyToPathBuilder builder = new V1KeyToPathBuilder(item);
            this._visitables.get("items").add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    public A addAllToItems(Collection<V1KeyToPath> items) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        for (V1KeyToPath item : items) {
            V1KeyToPathBuilder builder = new V1KeyToPathBuilder(item);
            this._visitables.get("items").add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    public A removeFromItems(V1KeyToPath ... items) {
        if (this.items == null) {
            return (A)this;
        }
        for (V1KeyToPath item : items) {
            V1KeyToPathBuilder builder = new V1KeyToPathBuilder(item);
            this._visitables.get("items").remove(builder);
            this.items.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromItems(Collection<V1KeyToPath> items) {
        if (this.items == null) {
            return (A)this;
        }
        for (V1KeyToPath item : items) {
            V1KeyToPathBuilder builder = new V1KeyToPathBuilder(item);
            this._visitables.get("items").remove(builder);
            this.items.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromItems(Predicate<V1KeyToPathBuilder> predicate) {
        if (this.items == null) {
            return (A)this;
        }
        Iterator<V1KeyToPathBuilder> each = this.items.iterator();
        Object visitables = this._visitables.get("items");
        while (each.hasNext()) {
            V1KeyToPathBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<V1KeyToPath> buildItems() {
        return this.items != null ? V1SecretVolumeSourceFluent.build(this.items) : null;
    }

    public V1KeyToPath buildItem(int index) {
        return this.items.get(index).build();
    }

    public V1KeyToPath buildFirstItem() {
        return this.items.get(0).build();
    }

    public V1KeyToPath buildLastItem() {
        return this.items.get(this.items.size() - 1).build();
    }

    public V1KeyToPath buildMatchingItem(Predicate<V1KeyToPathBuilder> predicate) {
        for (V1KeyToPathBuilder item : this.items) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingItem(Predicate<V1KeyToPathBuilder> predicate) {
        for (V1KeyToPathBuilder item : this.items) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withItems(List<V1KeyToPath> items) {
        if (this.items != null) {
            this._visitables.get("items").clear();
        }
        if (items != null) {
            this.items = new ArrayList();
            for (V1KeyToPath item : items) {
                this.addToItems(item);
            }
        } else {
            this.items = null;
        }
        return (A)this;
    }

    public A withItems(V1KeyToPath ... items) {
        if (this.items != null) {
            this.items.clear();
            this._visitables.remove("items");
        }
        if (items != null) {
            for (V1KeyToPath item : items) {
                this.addToItems(item);
            }
        }
        return (A)this;
    }

    public boolean hasItems() {
        return this.items != null && !this.items.isEmpty();
    }

    public ItemsNested<A> addNewItem() {
        return new ItemsNested(-1, null);
    }

    public ItemsNested<A> addNewItemLike(V1KeyToPath item) {
        return new ItemsNested(-1, item);
    }

    public ItemsNested<A> setNewItemLike(int index, V1KeyToPath item) {
        return new ItemsNested(index, item);
    }

    public ItemsNested<A> editItem(int index) {
        if (this.items.size() <= index) {
            throw new RuntimeException("Can't edit items. Index exceeds size.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    public ItemsNested<A> editFirstItem() {
        if (this.items.size() == 0) {
            throw new RuntimeException("Can't edit first items. The list is empty.");
        }
        return this.setNewItemLike(0, this.buildItem(0));
    }

    public ItemsNested<A> editLastItem() {
        int index = this.items.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last items. The list is empty.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    public ItemsNested<A> editMatchingItem(Predicate<V1KeyToPathBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.items.size(); ++i) {
            if (!predicate.test(this.items.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching items. No match found.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    public Boolean getOptional() {
        return this.optional;
    }

    public A withOptional(Boolean optional) {
        this.optional = optional;
        return (A)this;
    }

    public boolean hasOptional() {
        return this.optional != null;
    }

    public String getSecretName() {
        return this.secretName;
    }

    public A withSecretName(String secretName) {
        this.secretName = secretName;
        return (A)this;
    }

    public boolean hasSecretName() {
        return this.secretName != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1SecretVolumeSourceFluent that = (V1SecretVolumeSourceFluent)o;
        if (!Objects.equals(this.defaultMode, that.defaultMode)) {
            return false;
        }
        if (!Objects.equals(this.items, that.items)) {
            return false;
        }
        if (!Objects.equals(this.optional, that.optional)) {
            return false;
        }
        return Objects.equals(this.secretName, that.secretName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.defaultMode, this.items, this.optional, this.secretName, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.defaultMode != null) {
            sb.append("defaultMode:");
            sb.append(this.defaultMode + ",");
        }
        if (this.items != null && !this.items.isEmpty()) {
            sb.append("items:");
            sb.append(this.items + ",");
        }
        if (this.optional != null) {
            sb.append("optional:");
            sb.append(this.optional + ",");
        }
        if (this.secretName != null) {
            sb.append("secretName:");
            sb.append(this.secretName);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withOptional() {
        return this.withOptional(true);
    }

    public class ItemsNested<N>
    extends V1KeyToPathFluent<ItemsNested<N>>
    implements Nested<N> {
        V1KeyToPathBuilder builder;
        int index;

        ItemsNested(int index, V1KeyToPath item) {
            this.index = index;
            this.builder = new V1KeyToPathBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1SecretVolumeSourceFluent.this.setToItems(this.index, this.builder.build());
        }

        public N endItem() {
            return this.and();
        }
    }
}

