/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.custom.Quantity;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V1ResourceClaim;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class V1ResourceRequirements {
    public static final String SERIALIZED_NAME_CLAIMS = "claims";
    @SerializedName(value="claims")
    private List<V1ResourceClaim> claims;
    public static final String SERIALIZED_NAME_LIMITS = "limits";
    @SerializedName(value="limits")
    private Map<String, Quantity> limits = new HashMap<String, Quantity>();
    public static final String SERIALIZED_NAME_REQUESTS = "requests";
    @SerializedName(value="requests")
    private Map<String, Quantity> requests = new HashMap<String, Quantity>();
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1ResourceRequirements claims(List<V1ResourceClaim> claims) {
        this.claims = claims;
        return this;
    }

    public V1ResourceRequirements addClaimsItem(V1ResourceClaim claimsItem) {
        if (this.claims == null) {
            this.claims = new ArrayList<V1ResourceClaim>();
        }
        this.claims.add(claimsItem);
        return this;
    }

    @Nullable
    public List<V1ResourceClaim> getClaims() {
        return this.claims;
    }

    public void setClaims(List<V1ResourceClaim> claims) {
        this.claims = claims;
    }

    public V1ResourceRequirements limits(Map<String, Quantity> limits) {
        this.limits = limits;
        return this;
    }

    public V1ResourceRequirements putLimitsItem(String key, Quantity limitsItem) {
        if (this.limits == null) {
            this.limits = new HashMap<String, Quantity>();
        }
        this.limits.put(key, limitsItem);
        return this;
    }

    @Nullable
    public Map<String, Quantity> getLimits() {
        return this.limits;
    }

    public void setLimits(Map<String, Quantity> limits) {
        this.limits = limits;
    }

    public V1ResourceRequirements requests(Map<String, Quantity> requests) {
        this.requests = requests;
        return this;
    }

    public V1ResourceRequirements putRequestsItem(String key, Quantity requestsItem) {
        if (this.requests == null) {
            this.requests = new HashMap<String, Quantity>();
        }
        this.requests.put(key, requestsItem);
        return this;
    }

    @Nullable
    public Map<String, Quantity> getRequests() {
        return this.requests;
    }

    public void setRequests(Map<String, Quantity> requests) {
        this.requests = requests;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1ResourceRequirements v1ResourceRequirements = (V1ResourceRequirements)o;
        return Objects.equals(this.claims, v1ResourceRequirements.claims) && Objects.equals(this.limits, v1ResourceRequirements.limits) && Objects.equals(this.requests, v1ResourceRequirements.requests);
    }

    public int hashCode() {
        return Objects.hash(this.claims, this.limits, this.requests);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1ResourceRequirements {\n");
        sb.append("    claims: ").append(this.toIndentedString(this.claims)).append("\n");
        sb.append("    limits: ").append(this.toIndentedString(this.limits)).append("\n");
        sb.append("    requests: ").append(this.toIndentedString(this.requests)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        JsonArray jsonArrayclaims;
        if (jsonObj == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1ResourceRequirements is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1ResourceRequirements` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CLAIMS) != null && !jsonObj.get(SERIALIZED_NAME_CLAIMS).isJsonNull() && (jsonArrayclaims = jsonObj.getAsJsonArray(SERIALIZED_NAME_CLAIMS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_CLAIMS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `claims` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CLAIMS).toString()));
            }
            for (int i = 0; i < jsonArrayclaims.size(); ++i) {
                V1ResourceClaim.validateJsonObject(jsonArrayclaims.get(i).getAsJsonObject());
            }
        }
    }

    public static V1ResourceRequirements fromJson(String jsonString) throws IOException {
        return (V1ResourceRequirements)JSON.getGson().fromJson(jsonString, V1ResourceRequirements.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_CLAIMS);
        openapiFields.add(SERIALIZED_NAME_LIMITS);
        openapiFields.add(SERIALIZED_NAME_REQUESTS);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1ResourceRequirements.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1ResourceRequirements.class));
            return new TypeAdapter<V1ResourceRequirements>(){

                public void write(JsonWriter out, V1ResourceRequirements value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1ResourceRequirements read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    V1ResourceRequirements.validateJsonObject(jsonObj);
                    return (V1ResourceRequirements)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

